/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.recipes.inputs.ItemStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.GasStackIngredient;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class NucleosynthesizingRecipeBuilder
extends MekanismRecipeBuilder<NucleosynthesizingRecipeBuilder> {
    private final ItemStackIngredient itemInput;
    private final GasStackIngredient gasInput;
    private final ItemStack output;
    private final int duration;

    protected NucleosynthesizingRecipeBuilder(ItemStackIngredient itemInput, GasStackIngredient gasInput, ItemStack output, int duration) {
        super(NucleosynthesizingRecipeBuilder.mekSerializer("nucleosynthesizing"));
        this.itemInput = itemInput;
        this.gasInput = gasInput;
        this.output = output;
        this.duration = duration;
    }

    public static NucleosynthesizingRecipeBuilder nucleosynthesizing(ItemStackIngredient itemInput, GasStackIngredient gasInput, ItemStack output, int duration) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This nucleosynthesizing recipe requires a non empty item output.");
        }
        if (duration <= 0) {
            throw new IllegalArgumentException("This nucleosynthesizing recipe must have a positive duration.");
        }
        return new NucleosynthesizingRecipeBuilder(itemInput, gasInput, output, duration);
    }

    @Override
    protected NucleosynthesizingRecipeResult getResult(ResourceLocation id) {
        return new NucleosynthesizingRecipeResult(id);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output.func_77973_b().getRegistryName());
    }

    public class NucleosynthesizingRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected NucleosynthesizingRecipeResult(ResourceLocation id) {
            super(NucleosynthesizingRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("itemInput", NucleosynthesizingRecipeBuilder.this.itemInput.serialize());
            json.add("gasInput", NucleosynthesizingRecipeBuilder.this.gasInput.serialize());
            json.add("output", SerializerHelper.serializeItemStack(NucleosynthesizingRecipeBuilder.this.output));
            json.addProperty("duration", (Number)NucleosynthesizingRecipeBuilder.this.duration);
        }
    }
}

