/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.recipes.inputs.chemical.GasStackIngredient;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GasToGasRecipeBuilder
extends MekanismRecipeBuilder<GasToGasRecipeBuilder> {
    private final GasStackIngredient input;
    private final GasStack output;

    protected GasToGasRecipeBuilder(GasStackIngredient input, GasStack output, ResourceLocation serializerName) {
        super(serializerName);
        this.input = input;
        this.output = output;
    }

    public static GasToGasRecipeBuilder activating(GasStackIngredient input, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This solar neutron activator recipe requires a non empty gas output.");
        }
        return new GasToGasRecipeBuilder(input, output, GasToGasRecipeBuilder.mekSerializer("activating"));
    }

    public static GasToGasRecipeBuilder centrifuging(GasStackIngredient input, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This Isotopic Centrifuge recipe requires a non empty gas output.");
        }
        return new GasToGasRecipeBuilder(input, output, GasToGasRecipeBuilder.mekSerializer("centrifuging"));
    }

    @Override
    protected GasToGasRecipeResult getResult(ResourceLocation id) {
        return new GasToGasRecipeResult(id);
    }

    public class GasToGasRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected GasToGasRecipeResult(ResourceLocation id) {
            super(GasToGasRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("input", GasToGasRecipeBuilder.this.input.serialize());
            json.add("output", (JsonElement)SerializerHelper.serializeGasStack(GasToGasRecipeBuilder.this.output));
        }
    }
}

