/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.slurry.SlurryStack;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.recipes.inputs.FluidStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.SlurryStackIngredient;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidSlurryToSlurryRecipeBuilder
extends MekanismRecipeBuilder<FluidSlurryToSlurryRecipeBuilder> {
    private final SlurryStackIngredient slurryInput;
    private final FluidStackIngredient fluidInput;
    private final SlurryStack output;

    protected FluidSlurryToSlurryRecipeBuilder(FluidStackIngredient fluidInput, SlurryStackIngredient slurryInput, SlurryStack output) {
        super(FluidSlurryToSlurryRecipeBuilder.mekSerializer("washing"));
        this.fluidInput = fluidInput;
        this.slurryInput = slurryInput;
        this.output = output;
    }

    public static FluidSlurryToSlurryRecipeBuilder washing(FluidStackIngredient fluidInput, SlurryStackIngredient slurryInput, SlurryStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This washing recipe requires a non empty slurry output.");
        }
        return new FluidSlurryToSlurryRecipeBuilder(fluidInput, slurryInput, output);
    }

    @Override
    protected FluidSlurryToSlurryRecipeResult getResult(ResourceLocation id) {
        return new FluidSlurryToSlurryRecipeResult(id);
    }

    public class FluidSlurryToSlurryRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected FluidSlurryToSlurryRecipeResult(ResourceLocation id) {
            super(FluidSlurryToSlurryRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("fluidInput", FluidSlurryToSlurryRecipeBuilder.this.fluidInput.serialize());
            json.add("slurryInput", FluidSlurryToSlurryRecipeBuilder.this.slurryInput.serialize());
            json.add("output", (JsonElement)SerializerHelper.serializeSlurryStack(FluidSlurryToSlurryRecipeBuilder.this.output));
        }
    }
}

