/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.math.FloatingLong;
import com.qsoftware.modlib.api.recipes.inputs.FluidStackIngredient;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ElectrolysisRecipeBuilder
extends MekanismRecipeBuilder<ElectrolysisRecipeBuilder> {
    private final FluidStackIngredient input;
    private final GasStack leftGasOutput;
    private final GasStack rightGasOutput;
    private FloatingLong energyMultiplier = FloatingLong.ONE;

    protected ElectrolysisRecipeBuilder(FluidStackIngredient input, GasStack leftGasOutput, GasStack rightGasOutput) {
        super(ElectrolysisRecipeBuilder.mekSerializer("separating"));
        this.input = input;
        this.leftGasOutput = leftGasOutput;
        this.rightGasOutput = rightGasOutput;
    }

    public static ElectrolysisRecipeBuilder separating(FluidStackIngredient input, GasStack leftGasOutput, GasStack rightGasOutput) {
        if (leftGasOutput.isEmpty() || rightGasOutput.isEmpty()) {
            throw new IllegalArgumentException("This separating recipe requires non empty gas outputs.");
        }
        return new ElectrolysisRecipeBuilder(input, leftGasOutput, rightGasOutput);
    }

    public ElectrolysisRecipeBuilder energyMultiplier(FloatingLong multiplier) {
        if (multiplier.smallerThan(FloatingLong.ONE)) {
            throw new IllegalArgumentException("Energy multiplier must be greater than or equal to one");
        }
        this.energyMultiplier = multiplier;
        return this;
    }

    @Override
    protected ElectrolysisRecipeResult getResult(ResourceLocation id) {
        return new ElectrolysisRecipeResult(id);
    }

    public class ElectrolysisRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ElectrolysisRecipeResult(ResourceLocation id) {
            super(ElectrolysisRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("input", ElectrolysisRecipeBuilder.this.input.serialize());
            if (ElectrolysisRecipeBuilder.this.energyMultiplier.greaterThan(FloatingLong.ONE)) {
                json.addProperty("energyMultiplier", (Number)ElectrolysisRecipeBuilder.this.energyMultiplier);
            }
            json.add("leftGasOutput", (JsonElement)SerializerHelper.serializeGasStack(ElectrolysisRecipeBuilder.this.leftGasOutput));
            json.add("rightGasOutput", (JsonElement)SerializerHelper.serializeGasStack(ElectrolysisRecipeBuilder.this.rightGasOutput));
        }
    }
}

