/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.recipes.inputs.ItemStackIngredient;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CombinerRecipeBuilder
extends MekanismRecipeBuilder<CombinerRecipeBuilder> {
    private final ItemStackIngredient mainInput;
    private final ItemStackIngredient extraInput;
    private final ItemStack output;

    protected CombinerRecipeBuilder(ItemStackIngredient mainInput, ItemStackIngredient extraInput, ItemStack output) {
        super(CombinerRecipeBuilder.mekSerializer("combining"));
        this.mainInput = mainInput;
        this.extraInput = extraInput;
        this.output = output;
    }

    public static CombinerRecipeBuilder combining(ItemStackIngredient mainInput, ItemStackIngredient extraInput, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This combining recipe requires a non empty item output.");
        }
        return new CombinerRecipeBuilder(mainInput, extraInput, output);
    }

    @Override
    protected CombinerRecipeResult getResult(ResourceLocation id) {
        return new CombinerRecipeResult(id);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output.func_77973_b().getRegistryName());
    }

    public class CombinerRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected CombinerRecipeResult(ResourceLocation id) {
            super(CombinerRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("mainInput", CombinerRecipeBuilder.this.mainInput.serialize());
            json.add("extraInput", CombinerRecipeBuilder.this.extraInput.serialize());
            json.add("output", SerializerHelper.serializeItemStack(CombinerRecipeBuilder.this.output));
        }
    }
}

