/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.recipes.inputs.chemical.GasStackIngredient;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalInfuserRecipeBuilder
extends MekanismRecipeBuilder<ChemicalInfuserRecipeBuilder> {
    private final GasStackIngredient leftInput;
    private final GasStackIngredient rightInput;
    private final GasStack output;

    protected ChemicalInfuserRecipeBuilder(GasStackIngredient leftInput, GasStackIngredient rightInput, GasStack output) {
        super(ChemicalInfuserRecipeBuilder.mekSerializer("chemical_infusing"));
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.output = output;
    }

    public static ChemicalInfuserRecipeBuilder chemicalInfusing(GasStackIngredient leftInput, GasStackIngredient rightInput, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This chemical infusing recipe requires a non empty gas output.");
        }
        return new ChemicalInfuserRecipeBuilder(leftInput, rightInput, output);
    }

    @Override
    protected ChemicalInfuserRecipeResult getResult(ResourceLocation id) {
        return new ChemicalInfuserRecipeResult(id);
    }

    public class ChemicalInfuserRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ChemicalInfuserRecipeResult(ResourceLocation id) {
            super(ChemicalInfuserRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("leftInput", ChemicalInfuserRecipeBuilder.this.leftInput.serialize());
            json.add("rightInput", ChemicalInfuserRecipeBuilder.this.rightInput.serialize());
            json.add("output", (JsonElement)SerializerHelper.serializeGasStack(ChemicalInfuserRecipeBuilder.this.output));
        }
    }
}

