/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import com.qsoftware.modlib.api.SerializerHelper;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.ChemicalType;
import com.qsoftware.modlib.api.datagen.recipe.MekanismRecipeBuilder;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalCrystallizerRecipeBuilder
extends MekanismRecipeBuilder<ChemicalCrystallizerRecipeBuilder> {
    private final ChemicalType chemicalType;
    private final IChemicalStackIngredient<?, ?> input;
    private final ItemStack output;

    protected ChemicalCrystallizerRecipeBuilder(ResourceLocation serializerName, IChemicalStackIngredient<?, ?> input, ItemStack output) {
        super(serializerName);
        this.input = input;
        this.chemicalType = ChemicalType.getTypeFor(input);
        this.output = output;
    }

    public static ChemicalCrystallizerRecipeBuilder crystallizing(IChemicalStackIngredient<?, ?> input, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This crystallizing recipe requires a non empty item output.");
        }
        return new ChemicalCrystallizerRecipeBuilder(ChemicalCrystallizerRecipeBuilder.mekSerializer("crystallizing"), input, output);
    }

    @Override
    protected ChemicalCrystallizerRecipeResult getResult(ResourceLocation id) {
        return new ChemicalCrystallizerRecipeResult(id);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output.func_77973_b().getRegistryName());
    }

    public class ChemicalCrystallizerRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ChemicalCrystallizerRecipeResult(ResourceLocation id) {
            super(ChemicalCrystallizerRecipeBuilder.this, id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.addProperty("chemicalType", ChemicalCrystallizerRecipeBuilder.this.chemicalType.func_176610_l());
            json.add("input", ChemicalCrystallizerRecipeBuilder.this.input.serialize());
            json.add("output", SerializerHelper.serializeItemStack(ChemicalCrystallizerRecipeBuilder.this.output));
        }
    }
}

