/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical.slurry;

import com.qsoftware.modlib.api.chemical.ChemicalBuilder;
import com.qsoftware.modlib.api.chemical.slurry.Slurry;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SlurryBuilder
extends ChemicalBuilder<Slurry, SlurryBuilder> {
    @Nullable
    private ITag<Item> oreTag;

    protected SlurryBuilder(ResourceLocation texture) {
        super(texture);
    }

    public static SlurryBuilder clean() {
        return SlurryBuilder.builder(new ResourceLocation("mekanism", "slurry/clean"));
    }

    public static SlurryBuilder dirty() {
        return SlurryBuilder.builder(new ResourceLocation("mekanism", "slurry/dirty"));
    }

    public static SlurryBuilder builder(ResourceLocation texture) {
        return new SlurryBuilder(Objects.requireNonNull(texture));
    }

    public SlurryBuilder ore(ResourceLocation oreTagLocation) {
        return this.ore((ITag<Item>)ItemTags.func_199901_a((String)Objects.requireNonNull(oreTagLocation).toString()));
    }

    public SlurryBuilder ore(ITag<Item> oreTag) {
        this.oreTag = Objects.requireNonNull(oreTag);
        return this;
    }

    @Nullable
    public ITag<Item> getOreTag() {
        return this.oreTag;
    }
}

