/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical.slurry;

import com.qsoftware.modlib.api.MekanismAPI;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalTags;
import com.qsoftware.modlib.api.chemical.ChemicalUtils;
import com.qsoftware.modlib.api.chemical.slurry.SlurryBuilder;
import com.qsoftware.modlib.api.providers.ISlurryProvider;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Slurry
extends Chemical<Slurry>
implements ISlurryProvider {
    @Nullable
    private final ITag<Item> oreTag;

    public Slurry(SlurryBuilder builder) {
        super(builder, ChemicalTags.SLURRY);
        this.oreTag = builder.getOreTag();
    }

    public static Slurry readFromNBT(@Nullable CompoundNBT nbtTags) {
        return ChemicalUtils.readChemicalFromNBT(nbtTags, MekanismAPI.EMPTY_SLURRY, "slurryName", Slurry::getFromRegistry);
    }

    public static Slurry getFromRegistry(@Nullable ResourceLocation name) {
        return ChemicalUtils.readChemicalFromRegistry(name, MekanismAPI.EMPTY_SLURRY, MekanismAPI.slurryRegistry());
    }

    public String toString() {
        return "[Slurry: " + this.getRegistryName() + "]";
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74778_a("slurryName", this.getRegistryName().toString());
        return nbtTags;
    }

    @Override
    public final boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_SLURRY;
    }

    @Override
    protected String getDefaultTranslationKey() {
        return Util.func_200697_a((String)"slurry", (ResourceLocation)this.getRegistryName());
    }

    @Nullable
    public ITag<Item> getOreTag() {
        return this.oreTag;
    }
}

