/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical.pigment;

import com.qsoftware.modlib.api.MekanismAPI;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.pigment.Pigment;
import com.qsoftware.modlib.api.providers.IPigmentProvider;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PigmentStack
extends ChemicalStack<Pigment> {
    public static final PigmentStack EMPTY = new PigmentStack(MekanismAPI.EMPTY_PIGMENT, 0L);

    public PigmentStack(IPigmentProvider pigmentProvider, long amount) {
        super(pigmentProvider.getChemical(), amount);
    }

    public PigmentStack(PigmentStack stack, long amount) {
        this((IPigmentProvider)stack.getType(), amount);
    }

    public static PigmentStack readFromNBT(@Nullable CompoundNBT nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        Pigment type = Pigment.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.func_74763_f("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new PigmentStack(type, amount);
    }

    public static PigmentStack readFromPacket(PacketBuffer buf) {
        Pigment pigment = (Pigment)buf.readRegistryId();
        long amount = buf.func_179260_f();
        if (pigment.isEmptyType()) {
            return EMPTY;
        }
        return new PigmentStack(pigment, amount);
    }

    @Override
    protected IRegistryDelegate<Pigment> getDelegate(Pigment pigment) {
        if (MekanismAPI.pigmentRegistry().getKey((IForgeRegistryEntry)pigment) == null) {
            MekanismAPI.logger.fatal("Failed attempt to create a PigmentStack for an unregistered Pigment {} (type {})", (Object)pigment.getRegistryName(), (Object)pigment.getClass().getName());
            throw new IllegalArgumentException("Cannot create a PigmentStack from an unregistered Pigment");
        }
        return pigment.delegate;
    }

    @Override
    protected Pigment getEmptyChemical() {
        return MekanismAPI.EMPTY_PIGMENT;
    }

    public PigmentStack copy() {
        return new PigmentStack(this, this.getAmount());
    }
}

