/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical.attribute;

import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.attribute.ChemicalAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface ChemicalAttributeValidator {
    public static final ChemicalAttributeValidator DEFAULT = attr -> !attr.needsValidation();
    public static final ChemicalAttributeValidator ALWAYS_ALLOW = attr -> true;

    public static boolean process(Chemical<?> chemical, ChemicalAttributeValidator validator) {
        return chemical.getAttributes().stream().allMatch(validator::validate);
    }

    public static boolean process(ChemicalStack<?> stack, ChemicalAttributeValidator validator) {
        return ChemicalAttributeValidator.process(stack.getType(), validator);
    }

    @SafeVarargs
    public static ChemicalAttributeValidator create(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, true);
    }

    @SafeVarargs
    public static ChemicalAttributeValidator createStrict(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, false);
    }

    public boolean validate(ChemicalAttribute var1);

    public static class SimpleAttributeValidator
    implements ChemicalAttributeValidator {
        private final Set<Class<? extends ChemicalAttribute>> validTypes;
        private final boolean allowNoValidation;

        SimpleAttributeValidator(Class<? extends ChemicalAttribute>[] attributeTypes, boolean allowNoValidation) {
            this.validTypes = new HashSet<Class<? extends ChemicalAttribute>>(Arrays.asList(attributeTypes));
            this.allowNoValidation = allowNoValidation;
        }

        @Override
        public boolean validate(ChemicalAttribute attribute) {
            return this.validTypes.contains(attribute.getClass()) || this.allowNoValidation && !attribute.needsValidation();
        }
    }
}

