/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical;

import com.qsoftware.modlib.api.Action;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.chemical.infuse.InfusionStack;
import com.qsoftware.modlib.api.chemical.pigment.PigmentStack;
import com.qsoftware.modlib.api.chemical.slurry.SlurryStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.Function;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalUtils {
    public static void writeChemicalStack(PacketBuffer buffer, ChemicalStack<?> stack) {
        if (stack.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            stack.writeToPacket(buffer);
        }
    }

    public static GasStack readGasStack(PacketBuffer buffer) {
        return buffer.readBoolean() ? GasStack.readFromPacket(buffer) : GasStack.EMPTY;
    }

    public static InfusionStack readInfusionStack(PacketBuffer buffer) {
        return buffer.readBoolean() ? InfusionStack.readFromPacket(buffer) : InfusionStack.EMPTY;
    }

    public static PigmentStack readPigmentStack(PacketBuffer buffer) {
        return buffer.readBoolean() ? PigmentStack.readFromPacket(buffer) : PigmentStack.EMPTY;
    }

    public static SlurryStack readSlurryStack(PacketBuffer buffer) {
        return buffer.readBoolean() ? SlurryStack.readFromPacket(buffer) : SlurryStack.EMPTY;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> CHEMICAL readChemicalFromNBT(@Nullable CompoundNBT nbtTags, CHEMICAL empty, String nbtName, Function<ResourceLocation, CHEMICAL> registryLookup) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return empty;
        }
        return (CHEMICAL)((Chemical)registryLookup.apply(new ResourceLocation(nbtTags.func_74779_i(nbtName))));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> CHEMICAL readChemicalFromRegistry(@Nullable ResourceLocation name, CHEMICAL empty, IForgeRegistry<CHEMICAL> registry) {
        if (name == null) {
            return empty;
        }
        Chemical chemical = (Chemical)registry.getValue(name);
        if (chemical == null) {
            return empty;
        }
        return (CHEMICAL)chemical;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK insert(STACK stack, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NonNull STACK> inTankGetter, InsertChemical<STACK> insertChemical) {
        STACK remainder;
        int tank;
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            return insertChemical.insert(0, stack, action);
        }
        IntArrayList matchingTanks = new IntArrayList();
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank2 = 0; tank2 < tanks; ++tank2) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.get(tank2);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank2);
                continue;
            }
            if (!inTank.isTypeEqual(stack)) continue;
            matchingTanks.add(tank2);
        }
        STACK toInsert = stack;
        IntListIterator intListIterator = matchingTanks.iterator();
        while (intListIterator.hasNext()) {
            tank = (Integer)intListIterator.next();
            remainder = insertChemical.insert(tank, toInsert, action);
            if (((ChemicalStack)remainder).isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            tank = (Integer)intListIterator.next();
            remainder = insertChemical.insert(tank, toInsert, action);
            if (((ChemicalStack)remainder).isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(long amount, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NonNull STACK> inTankGetter, ExtractChemical<STACK> extractChemical) {
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            return extractChemical.extract(0, amount, action);
        }
        STACK extracted = empty;
        long toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            STACK drained;
            if (!extracted.isEmpty() && !extracted.isTypeEqual((ChemicalStack)((ChemicalStack)inTankGetter.get(tank))) || ((ChemicalStack)(drained = extractChemical.extract(tank, toDrain, action))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(STACK stack, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NonNull STACK> inTankGetter, ExtractChemical<STACK> extractChemical) {
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.get(0);
            if (inTank.isEmpty() || !inTank.isTypeEqual(stack)) {
                return empty;
            }
            return extractChemical.extract(0, stack.getAmount(), action);
        }
        STACK extracted = empty;
        long toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            STACK drained;
            if (!stack.isTypeEqual((ChemicalStack)((ChemicalStack)inTankGetter.get(tank))) || ((ChemicalStack)(drained = extractChemical.extract(tank, toDrain, action))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) == 0L) break;
        }
        return extracted;
    }

    @FunctionalInterface
    public static interface StackToStackCreator<STACK extends ChemicalStack<?>> {
        public STACK createStack(STACK var1, long var2);
    }

    @FunctionalInterface
    public static interface ChemicalToStackCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> {
        public STACK createStack(CHEMICAL var1, long var2);
    }

    @FunctionalInterface
    public static interface ExtractChemical<STACK extends ChemicalStack<?>> {
        public STACK extract(int var1, long var2, Action var4);
    }

    @FunctionalInterface
    public static interface InsertChemical<STACK extends ChemicalStack<?>> {
        public STACK insert(int var1, STACK var2, Action var3);
    }
}

