/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical;

import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.gas.Gas;
import com.qsoftware.modlib.api.chemical.infuse.InfuseType;
import com.qsoftware.modlib.api.chemical.pigment.Pigment;
import com.qsoftware.modlib.api.chemical.slurry.Slurry;
import com.qsoftware.modlib.api.recipes.inputs.chemical.GasStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.InfusionStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.PigmentStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.SlurryStackIngredient;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IStringSerializable;

public enum ChemicalType implements IStringSerializable
{
    GAS("gas", c -> c instanceof Gas),
    INFUSION("infuse_type", c -> c instanceof InfuseType),
    PIGMENT("pigment", c -> c instanceof Pigment),
    SLURRY("slurry", c -> c instanceof Slurry);

    private static final Map<String, ChemicalType> nameToType;
    private final Predicate<Chemical<?>> instanceCheck;
    private final String name;

    private ChemicalType(String name, Predicate<Chemical<?>> instanceCheck) {
        this.name = name;
        this.instanceCheck = instanceCheck;
    }

    @Nullable
    public static ChemicalType fromString(String name) {
        return nameToType.get(name);
    }

    @Nullable
    public static ChemicalType fromNBT(@Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_150297_b("chemicalType", 8)) {
            return ChemicalType.fromString(nbt.func_74779_i("chemicalType"));
        }
        return null;
    }

    public static ChemicalType getTypeFor(Chemical<?> chemical) {
        if (chemical instanceof Gas) {
            return GAS;
        }
        if (chemical instanceof InfuseType) {
            return INFUSION;
        }
        if (chemical instanceof Pigment) {
            return PIGMENT;
        }
        if (chemical instanceof Slurry) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public static ChemicalType getTypeFor(ChemicalStack<?> stack) {
        return ChemicalType.getTypeFor(stack.getType());
    }

    public static ChemicalType getTypeFor(IChemicalStackIngredient<?, ?> ingredient) {
        if (ingredient instanceof GasStackIngredient) {
            return GAS;
        }
        if (ingredient instanceof InfusionStackIngredient) {
            return INFUSION;
        }
        if (ingredient instanceof PigmentStackIngredient) {
            return PIGMENT;
        }
        if (ingredient instanceof SlurryStackIngredient) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical ingredient type");
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public boolean isInstance(Chemical<?> chemical) {
        return this.instanceCheck.test(chemical);
    }

    public void write(@Nonnull CompoundNBT nbt) {
        nbt.func_74778_a("chemicalType", this.func_176610_l());
    }

    static {
        nameToType = new Object2ObjectOpenHashMap();
        for (ChemicalType type : ChemicalType.values()) {
            nameToType.put(type.func_176610_l(), type);
        }
    }
}

