/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical;

import com.qsoftware.modlib.api.IContentsListener;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.BasicChemicalTank;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.IChemicalTank;
import com.qsoftware.modlib.api.chemical.attribute.ChemicalAttributeValidator;
import com.qsoftware.modlib.api.chemical.gas.Gas;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.chemical.gas.IGasHandler;
import com.qsoftware.modlib.api.chemical.gas.IGasTank;
import com.qsoftware.modlib.api.chemical.infuse.IInfusionHandler;
import com.qsoftware.modlib.api.chemical.infuse.IInfusionTank;
import com.qsoftware.modlib.api.chemical.infuse.InfuseType;
import com.qsoftware.modlib.api.chemical.infuse.InfusionStack;
import com.qsoftware.modlib.api.chemical.pigment.IPigmentHandler;
import com.qsoftware.modlib.api.chemical.pigment.IPigmentTank;
import com.qsoftware.modlib.api.chemical.pigment.Pigment;
import com.qsoftware.modlib.api.chemical.pigment.PigmentStack;
import com.qsoftware.modlib.api.chemical.slurry.ISlurryHandler;
import com.qsoftware.modlib.api.chemical.slurry.ISlurryTank;
import com.qsoftware.modlib.api.chemical.slurry.Slurry;
import com.qsoftware.modlib.api.chemical.slurry.SlurryStack;
import com.qsoftware.modlib.api.inventory.AutomationType;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalTankBuilder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
    public static final ChemicalTankBuilder<Gas, GasStack, IGasTank> GAS = new ChemicalTankBuilder(BasicGasTank::new);
    public static final ChemicalTankBuilder<InfuseType, InfusionStack, IInfusionTank> INFUSION = new ChemicalTankBuilder(BasicInfusionTank::new);
    public static final ChemicalTankBuilder<Pigment, PigmentStack, IPigmentTank> PIGMENT = new ChemicalTankBuilder(BasicPigmentTank::new);
    public static final ChemicalTankBuilder<Slurry, SlurryStack, ISlurryTank> SLURRY = new ChemicalTankBuilder(BasicSlurryTank::new);
    public final Predicate<@NonNull CHEMICAL> alwaysTrue = stack -> true;
    public final Predicate<@NonNull CHEMICAL> alwaysFalse = stack -> false;
    public final BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> alwaysTrueBi = (stack, automationType) -> true;
    public final BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> internalOnly = (stack, automationType) -> automationType == AutomationType.INTERNAL;
    public final BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> notExternal = (stack, automationType) -> automationType != AutomationType.EXTERNAL;
    private final BasicTankCreator<CHEMICAL, STACK, TANK> tankCreator;

    private ChemicalTankBuilder(BasicTankCreator<CHEMICAL, STACK, TANK> tankCreator) {
        this.tankCreator = tankCreator;
    }

    public TANK createDummy(long capacity) {
        return this.createAllValid(capacity, null);
    }

    public TANK create(long capacity, @Nullable IContentsListener listener) {
        return this.createWithValidator(capacity, null, listener);
    }

    public TANK createWithValidator(long capacity, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return this.tankCreator.create(capacity, this.alwaysTrueBi, this.alwaysTrueBi, this.alwaysTrue, attributeValidator, listener);
    }

    public TANK createAllValid(long capacity, @Nullable IContentsListener listener) {
        return this.createWithValidator(capacity, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    public TANK create(long capacity, Predicate<@NonNull CHEMICAL> canExtract, Predicate<@NonNull CHEMICAL> canInsert, @Nullable IContentsListener listener) {
        return this.create(capacity, canExtract, canInsert, this.alwaysTrue, listener);
    }

    public TANK create(long capacity, Predicate<@NonNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, this.alwaysTrueBi, this.alwaysTrueBi, validator, null, listener);
    }

    public TANK input(long capacity, Predicate<@NonNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, this.notExternal, this.alwaysTrueBi, validator, null, listener);
    }

    public TANK input(long capacity, Predicate<@NonNull CHEMICAL> canInsert, Predicate<@NonNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, this.notExternal, (CHEMICAL stack, AutomationType automationType) -> canInsert.test(stack), validator, null, listener);
    }

    public TANK output(long capacity, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return this.tankCreator.create(capacity, this.alwaysTrueBi, this.internalOnly, this.alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    public TANK ejectOutput(long capacity, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return this.tankCreator.create(capacity, this.internalOnly, this.internalOnly, this.alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    public TANK create(long capacity, Predicate<@NonNull CHEMICAL> canExtract, Predicate<@NonNull CHEMICAL> canInsert, Predicate<@NonNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        return this.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public TANK create(long capacity, BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> canExtract, BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> canInsert, Predicate<@NonNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        return this.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public TANK create(long capacity, Predicate<@NonNull CHEMICAL> canExtract, Predicate<@NonNull CHEMICAL> canInsert, Predicate<@NonNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.createUnchecked(capacity, canExtract, canInsert, validator, attributeValidator, listener);
    }

    public TANK create(long capacity, BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> canExtract, BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> canInsert, Predicate<@NonNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, canExtract, canInsert, validator, attributeValidator, listener);
    }

    private TANK createUnchecked(long capacity, Predicate<@NonNull CHEMICAL> canExtract, Predicate<@NonNull CHEMICAL> canInsert, Predicate<@NonNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        return this.tankCreator.create(capacity, (CHEMICAL stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test(stack), (CHEMICAL stack, AutomationType automationType) -> canInsert.test(stack), validator, attributeValidator, listener);
    }

    public static class BasicSlurryTank
    extends BasicChemicalTank<Slurry, SlurryStack>
    implements ISlurryHandler,
    ISlurryTank {
        protected BasicSlurryTank(long capacity, BiPredicate<@NonNull Slurry, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Slurry, @NonNull AutomationType> canInsert, Predicate<@NonNull Slurry> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    public static class BasicPigmentTank
    extends BasicChemicalTank<Pigment, PigmentStack>
    implements IPigmentHandler,
    IPigmentTank {
        protected BasicPigmentTank(long capacity, BiPredicate<@NonNull Pigment, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Pigment, @NonNull AutomationType> canInsert, Predicate<@NonNull Pigment> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    public static class BasicInfusionTank
    extends BasicChemicalTank<InfuseType, InfusionStack>
    implements IInfusionHandler,
    IInfusionTank {
        protected BasicInfusionTank(long capacity, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canExtract, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    public static class BasicGasTank
    extends BasicChemicalTank<Gas, GasStack>
    implements IGasHandler,
    IGasTank {
        protected BasicGasTank(long capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    @FunctionalInterface
    private static interface BasicTankCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
        public TANK create(long var1, BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> var3, BiPredicate<@NonNull CHEMICAL, @NonNull AutomationType> var4, Predicate<@NonNull CHEMICAL> var5, @Nullable ChemicalAttributeValidator var6, @Nullable IContentsListener var7);
    }
}

