/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.chemical;

import com.qsoftware.modlib.api.MekanismAPI;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.gas.Gas;
import com.qsoftware.modlib.api.chemical.infuse.InfuseType;
import com.qsoftware.modlib.api.chemical.pigment.Pigment;
import com.qsoftware.modlib.api.chemical.slurry.Slurry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistry;

public class ChemicalTags<CHEMICAL extends Chemical<CHEMICAL>> {
    public static final ChemicalTags<Gas> GAS = new ChemicalTags(new ResourceLocation("mekanism", "gas"), MekanismAPI::gasRegistry);
    public static final ChemicalTags<InfuseType> INFUSE_TYPE = new ChemicalTags(new ResourceLocation("mekanism", "infuse_type"), MekanismAPI::infuseTypeRegistry);
    public static final ChemicalTags<Pigment> PIGMENT = new ChemicalTags(new ResourceLocation("mekanism", "pigment"), MekanismAPI::pigmentRegistry);
    public static final ChemicalTags<Slurry> SLURRY = new ChemicalTags(new ResourceLocation("mekanism", "slurry"), MekanismAPI::slurryRegistry);
    private final Supplier<IForgeRegistry<CHEMICAL>> registrySupplier;
    private final ResourceLocation registryName;

    private ChemicalTags(ResourceLocation registryName, Supplier<IForgeRegistry<CHEMICAL>> registrySupplier) {
        this.registrySupplier = registrySupplier;
        this.registryName = registryName;
    }

    public ITagCollection<CHEMICAL> getCollection() {
        IForgeRegistry<CHEMICAL> registry = this.registrySupplier.get();
        if (registry == null) {
            return TagCollectionManager.func_242178_a().getCustomTypeCollection(this.registryName);
        }
        return TagCollectionManager.func_242178_a().getCustomTypeCollection(registry);
    }

    public ResourceLocation lookupTag(ITag<CHEMICAL> tag) {
        ITagCollection<CHEMICAL> collection = this.getCollection();
        ResourceLocation resourceLocation = collection.func_232973_a_(tag);
        if (resourceLocation == null) {
            List chemicals = tag.func_230236_b_();
            for (Map.Entry entry : collection.func_241833_a().entrySet()) {
                if (!chemicals.equals(((ITag)entry.getValue()).func_230236_b_())) continue;
                resourceLocation = (ResourceLocation)entry.getKey();
                break;
            }
        }
        if (resourceLocation == null) {
            throw new IllegalStateException("Unrecognized tag");
        }
        return resourceLocation;
    }

    public ITag.INamedTag<CHEMICAL> tag(ResourceLocation name) {
        IForgeRegistry<CHEMICAL> registry = this.registrySupplier.get();
        if (registry == null) {
            return ForgeTagHandler.makeWrapperTag((ResourceLocation)this.registryName, (ResourceLocation)name);
        }
        return ForgeTagHandler.makeWrapperTag(registry, (ResourceLocation)name);
    }

    public Tags.IOptionalNamedTag<CHEMICAL> optionalTag(ResourceLocation name) {
        return this.optionalTag(name, null);
    }

    public Tags.IOptionalNamedTag<CHEMICAL> optionalTag(ResourceLocation name, @Nullable Set<Supplier<CHEMICAL>> defaults) {
        IForgeRegistry<CHEMICAL> registry = this.registrySupplier.get();
        if (registry == null) {
            return ForgeTagHandler.createOptionalTag((ResourceLocation)this.registryName, (ResourceLocation)name, defaults);
        }
        return ForgeTagHandler.createOptionalTag(registry, (ResourceLocation)name, defaults);
    }
}

