/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.ChemicalType;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.chemical.infuse.InfusionStack;
import com.qsoftware.modlib.api.chemical.merged.BoxedChemicalStack;
import com.qsoftware.modlib.api.chemical.pigment.PigmentStack;
import com.qsoftware.modlib.api.chemical.slurry.SlurryStack;
import com.qsoftware.modlib.api.math.FloatingLong;
import com.qsoftware.modlib.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SerializerHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerHelper() {
    }

    public static FloatingLong getFloatingLong(@Nonnull JsonObject json, @Nonnull String key) {
        if (!json.has(key)) {
            throw new JsonSyntaxException("Missing '" + key + "', expected to find an object");
        }
        JsonElement jsonElement = json.get(key);
        if (!jsonElement.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a json primitive representing a FloatingLong");
        }
        try {
            return FloatingLong.parseFloatingLong(jsonElement.getAsNumber().toString(), true);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a valid FloatingLong (positive decimal number)");
        }
    }

    private static void validateKey(@Nonnull JsonObject json, @Nonnull String key) {
        if (!json.has(key)) {
            throw new JsonSyntaxException("Missing '" + key + "', expected to find an object");
        }
        if (!json.get(key).isJsonObject()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be an object");
        }
    }

    public static ChemicalType getChemicalType(@Nonnull JsonObject json) {
        if (!json.has("chemicalType")) {
            throw new JsonSyntaxException("Missing 'chemicalType', expected to find a string");
        }
        JsonElement element = json.get("chemicalType");
        if (!element.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected 'chemicalType' to be a json primitive representing a string");
        }
        String name = element.getAsString();
        ChemicalType chemicalType = ChemicalType.fromString(name);
        if (chemicalType == null) {
            throw new JsonSyntaxException("Invalid chemical type '" + name + "'.");
        }
        return chemicalType;
    }

    public static ItemStack getItemStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static FluidStack getFluidStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static ChemicalStack<?> getBoxedChemicalStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        JsonObject jsonObject = JSONUtils.func_152754_s((JsonObject)json, (String)key);
        ChemicalType chemicalType = SerializerHelper.getChemicalType(jsonObject);
        if (chemicalType == ChemicalType.GAS) {
            return SerializerHelper.deserializeGas(jsonObject);
        }
        if (chemicalType == ChemicalType.INFUSION) {
            return SerializerHelper.deserializeInfuseType(jsonObject);
        }
        if (chemicalType == ChemicalType.PIGMENT) {
            return SerializerHelper.deserializePigment(jsonObject);
        }
        if (chemicalType == ChemicalType.SLURRY) {
            return SerializerHelper.deserializeSlurry(jsonObject);
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public static GasStack getGasStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeGas(JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static InfusionStack getInfusionStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeInfuseType(JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static PigmentStack getPigmentStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializePigment(JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static SlurryStack getSlurryStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeSlurry(JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static GasStack deserializeGas(@Nonnull JsonObject json) {
        return ChemicalIngredientDeserializer.GAS.deserializeStack(json);
    }

    public static FluidStack deserializeFluid(@Nonnull JsonObject json) {
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
        }
        JsonElement count = json.get("amount");
        if (!JSONUtils.func_188175_b((JsonElement)count)) {
            throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
        }
        int amount = count.getAsJsonPrimitive().getAsInt();
        if (amount < 1) {
            throw new JsonSyntaxException("Expected amount to be greater than zero.");
        }
        ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        if (fluid == null || fluid == Fluids.field_204541_a) {
            throw new JsonSyntaxException("Invalid fluid type '" + resourceLocation + "'");
        }
        CompoundNBT nbt = null;
        if (json.has("nbt")) {
            JsonElement jsonNBT = json.get("nbt");
            try {
                nbt = jsonNBT.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(jsonNBT)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)jsonNBT, (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT entry for fluid '" + resourceLocation + "'");
            }
        }
        return new FluidStack(fluid, amount, nbt);
    }

    public static InfusionStack deserializeInfuseType(@Nonnull JsonObject json) {
        return ChemicalIngredientDeserializer.INFUSION.deserializeStack(json);
    }

    public static PigmentStack deserializePigment(@Nonnull JsonObject json) {
        return ChemicalIngredientDeserializer.PIGMENT.deserializeStack(json);
    }

    public static SlurryStack deserializeSlurry(@Nonnull JsonObject json) {
        return ChemicalIngredientDeserializer.SLURRY.deserializeStack(json);
    }

    public static JsonElement serializeItemStack(@Nonnull ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        if (stack.func_190916_E() > 1) {
            json.addProperty("count", (Number)stack.func_190916_E());
        }
        if (stack.func_77942_o()) {
            json.addProperty("nbt", stack.func_77978_p().toString());
        }
        return json;
    }

    public static JsonElement serializeFluidStack(@Nonnull FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", stack.getFluid().getRegistryName().toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    public static JsonElement serializeBoxedChemicalStack(@Nonnull BoxedChemicalStack stack) {
        JsonObject json;
        ChemicalType chemicalType = stack.getChemicalType();
        if (chemicalType == ChemicalType.GAS) {
            json = SerializerHelper.serializeGasStack((GasStack)stack.getChemicalStack());
        } else if (chemicalType == ChemicalType.INFUSION) {
            json = SerializerHelper.serializeInfusionStack((InfusionStack)stack.getChemicalStack());
        } else if (chemicalType == ChemicalType.PIGMENT) {
            json = SerializerHelper.serializePigmentStack((PigmentStack)stack.getChemicalStack());
        } else if (chemicalType == ChemicalType.SLURRY) {
            json = SerializerHelper.serializeSlurryStack((SlurryStack)stack.getChemicalStack());
        } else {
            throw new IllegalStateException("Unknown chemical type");
        }
        json.addProperty("chemicalType", chemicalType.func_176610_l());
        return json;
    }

    public static JsonObject serializeGasStack(@Nonnull GasStack stack) {
        return ChemicalIngredientDeserializer.GAS.serializeStack(stack);
    }

    public static JsonObject serializeInfusionStack(@Nonnull InfusionStack stack) {
        return ChemicalIngredientDeserializer.INFUSION.serializeStack(stack);
    }

    public static JsonObject serializePigmentStack(@Nonnull PigmentStack stack) {
        return ChemicalIngredientDeserializer.PIGMENT.serializeStack(stack);
    }

    public static JsonObject serializeSlurryStack(@Nonnull SlurryStack stack) {
        return ChemicalIngredientDeserializer.SLURRY.serializeStack(stack);
    }

    public static ChemicalIngredientDeserializer<?, ?, ?> getDeserializerForType(ChemicalType chemicalType) {
        if (chemicalType == ChemicalType.GAS) {
            return ChemicalIngredientDeserializer.GAS;
        }
        if (chemicalType == ChemicalType.INFUSION) {
            return ChemicalIngredientDeserializer.INFUSION;
        }
        if (chemicalType == ChemicalType.PIGMENT) {
            return ChemicalIngredientDeserializer.PIGMENT;
        }
        if (chemicalType == ChemicalType.SLURRY) {
            return ChemicalIngredientDeserializer.SLURRY;
        }
        throw new IllegalStateException("Unknown Chemical Type");
    }
}

