/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api;

import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public enum RedstoneMode {
    IGNORED(new ResourceLocation("textures/item/barrier.png")),
    ON(new ResourceLocation("textures/block/redstone_torch.png")),
    OFF(new ResourceLocation("textures/block/redstone_torch_off.png"));

    private final ResourceLocation texture;

    private RedstoneMode(ResourceLocation texture) {
        this.texture = texture;
    }

    @Nullable
    public static RedstoneMode byName(String name) {
        for (RedstoneMode mode : RedstoneMode.values()) {
            if (!mode.name().equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public boolean shouldRun(boolean isPowered) {
        if (this == ON) {
            return isPowered;
        }
        if (this == OFF) {
            return !isPowered;
        }
        return true;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

