/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api;

import com.qsoftware.modlib.api.chemical.IChemicalTank;
import com.qsoftware.modlib.api.energy.IEnergyContainer;
import com.qsoftware.modlib.api.heat.IHeatCapacitor;
import com.qsoftware.modlib.api.inventory.IInventorySlot;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.IFluidTank;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DataHandlerUtils {
    private DataHandlerUtils() {
    }

    public static void readContainers(List<? extends INBTSerializable<CompoundNBT>> containers, ListNBT storedContainers) {
        DataHandlerUtils.readContents(containers, storedContainers, DataHandlerUtils.getTagByType(containers));
    }

    public static ListNBT writeContainers(List<? extends INBTSerializable<CompoundNBT>> containers) {
        return DataHandlerUtils.writeContents(containers, DataHandlerUtils.getTagByType(containers));
    }

    public static void readContents(List<? extends INBTSerializable<CompoundNBT>> contents, ListNBT storedContents, String key) {
        int size = contents.size();
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            CompoundNBT tagCompound = storedContents.func_150305_b(tagCount);
            byte id = tagCompound.func_74771_c(key);
            if (id < 0 || id >= size) continue;
            contents.get(id).deserializeNBT((INBT)tagCompound);
        }
    }

    public static ListNBT writeContents(List<? extends INBTSerializable<CompoundNBT>> contents, String key) {
        ListNBT storedContents = new ListNBT();
        for (int tank = 0; tank < contents.size(); ++tank) {
            CompoundNBT tagCompound = (CompoundNBT)contents.get(tank).serializeNBT();
            if (tagCompound.isEmpty()) continue;
            tagCompound.func_74774_a(key, (byte)tank);
            storedContents.add((Object)tagCompound);
        }
        return storedContents;
    }

    private static String getTagByType(List<? extends INBTSerializable<CompoundNBT>> containers) {
        if (containers.isEmpty()) {
            return "Container";
        }
        INBTSerializable<CompoundNBT> obj = containers.get(0);
        if (obj instanceof IChemicalTank || obj instanceof IFluidTank) {
            return "Tank";
        }
        if (obj instanceof IHeatCapacitor || obj instanceof IEnergyContainer) {
            return "Container";
        }
        if (obj instanceof IInventorySlot) {
            return "Slot";
        }
        return "Container";
    }

    public static int getMaxId(ListNBT storedContents, String key) {
        byte maxId = -1;
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            byte id = storedContents.func_150305_b(tagCount).func_74771_c(key);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId + 1;
    }
}

