/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib;

import com.qsoftware.modlib.SideProxy;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="qmodlib")
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class QModLib {
    public static final String MOD_ID = "qmodlib";
    public static final String MOD_NAME = "QModLib";
    public static final Logger LOGGER = LogManager.getLogger((String)"QModLib");
    public static final Random RANDOM = new Random();
    @Nullable
    private static QModLib instance;
    @Nullable
    private static SideProxy proxy;

    public QModLib() {
        instance = this;
        proxy = (SideProxy)DistExecutor.safeRunForDist(() -> SideProxy.Client::new, () -> SideProxy.Server::new);
    }

    public static String getVersion() {
        Optional o = ModList.get().getModContainerById(MOD_ID);
        if (o.isPresent()) {
            return ((ModContainer)o.get()).getModInfo().getVersion().toString();
        }
        return "0.0.0";
    }

    public static boolean isDevBuild() {
        return "NONE".equals(QModLib.getVersion());
    }

    public static ResourceLocation getId(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @Nullable
    public static QModLib getInstance() {
        return instance;
    }

    @Nullable
    public static SideProxy getProxy() {
        return proxy;
    }
}

