/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.datetime.v0;

import java.io.Serializable;
import java.time.LocalDateTime;

public class Time
implements Comparable<Time>,
Serializable {
    private int hour;
    private int minute;
    private int second;

    public static Time current() {
        LocalDateTime dateTime = LocalDateTime.now();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        return new Time(hour, minute, second);
    }

    public Time(int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public int toSeconds() {
        int sec = this.second;
        sec += this.minute * 60;
        return sec += this.hour * 3600;
    }

    public float toMinutes() {
        float min = (float)this.second / 60.0f;
        min += (float)this.minute;
        return min += (float)this.hour * 60.0f;
    }

    public float toHours() {
        float hor = (float)this.second / 3600.0f;
        hor += (float)this.minute / 60.0f;
        return hor += (float)this.hour;
    }

    public boolean isBetween(Time lo, Time hi) {
        if (lo.toSeconds() > hi.toSeconds()) {
            throw new NullPointerException();
        }
        return lo.toSeconds() <= this.toSeconds() && hi.toSeconds() >= this.toSeconds();
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    @Override
    public int compareTo(Time o) {
        return Integer.compare(this.toSeconds(), o.toSeconds());
    }
}

