/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data;

import com.ultreon.data.DataTypeException;
import com.ultreon.data.FutureVersionException;
import com.ultreon.data.TypeRegistry;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DataIo {
    private static final short VERSION = 1;
    private static final int HEADER = -8371607;

    @SafeVarargs
    public static <T extends IType<?>> T read(File file, T ... type) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            IType iType = DataIo.read((InputStream)stream, type);
            return (T)iType;
        }
    }

    @SafeVarargs
    public static <T extends IType<?>> T read(InputStream stream, T ... type) throws IOException {
        byte id;
        DataInputStream inputStream = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
        int magic = inputStream.readInt();
        if (magic != -8371607) {
            throw new StreamCorruptedException(String.format("Invalid header got 0x%08X (expected 0xFF804269)", magic));
        }
        short readVersion = inputStream.readShort();
        if (readVersion > 1) {
            throw new FutureVersionException(readVersion, 1);
        }
        Class<?> componentType = type.getClass().getComponentType();
        int componentId = TypeRegistry.getId(componentType);
        if (componentId != (id = inputStream.readByte())) {
            throw new DataTypeException("The read data id " + id + " is different from the expected id: " + componentId);
        }
        return (T)TypeRegistry.read(id, inputStream);
    }

    @SafeVarargs
    public static <T extends IType<?>> T readCompressed(File file, T ... type) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            IType iType = DataIo.readCompressed((InputStream)stream, type);
            return (T)iType;
        }
    }

    @SafeVarargs
    public static <T extends IType<?>> T readCompressed(URL url, T ... type) throws IOException {
        try (InputStream stream = url.openStream();){
            IType iType = DataIo.readCompressed((InputStream)stream, type);
            return (T)iType;
        }
    }

    @SafeVarargs
    public static <T extends IType<?>> T readCompressed(InputStream stream, T ... type) throws IOException {
        GZIPInputStream gzipStream = new GZIPInputStream(stream);
        return (T)DataIo.read((InputStream)gzipStream, type);
    }

    public static void write(IType<?> type, File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            DataIo.write(type, stream);
        }
    }

    public static void write(IType<?> type, OutputStream stream) throws IOException {
        DataOutputStream outputStream = stream instanceof DataOutputStream ? (DataOutputStream)stream : new DataOutputStream(stream);
        outputStream.writeInt(-8371607);
        outputStream.writeShort(1);
        outputStream.writeByte(type.id());
        type.write(outputStream);
        outputStream.flush();
    }

    public static void writeCompressed(IType<?> type, URL file) throws IOException {
        try (OutputStream stream = file.openConnection().getOutputStream();){
            DataIo.writeCompressed(type, stream);
        }
    }

    public static void writeCompressed(IType<?> type, File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            DataIo.writeCompressed(type, stream);
        }
    }

    public static void writeCompressed(IType<?> type, OutputStream stream) throws IOException {
        GZIPOutputStream gzipStream = new GZIPOutputStream(stream);
        DataIo.write(type, gzipStream);
        gzipStream.finish();
        gzipStream.flush();
    }
}

