/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0.util;

import com.ultreon.libs.commons.v0.UtilityClass;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;

public final class StringUtils
extends UtilityClass {
    public static int count(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static List<String> wrap(String str, FontMetrics fm, int maxWidth) {
        List<String> lines = StringUtils.splitIntoLines(str);
        if (lines.size() == 0) {
            return lines;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (String line : lines) {
            StringUtils.wrapLineInto(line, strings, fm, maxWidth);
        }
        return strings;
    }

    public static void wrapLineInto(String line, List<String> list, FontMetrics fm, int maxWidth) {
        int width;
        int len = line.length();
        while (len > 0 && (width = fm.stringWidth(line)) > maxWidth) {
            int pos;
            int guess = len * maxWidth / width;
            String before = line.substring(0, guess).trim();
            if ((width = fm.stringWidth(before)) > maxWidth) {
                pos = StringUtils.findBreakBefore(line, guess);
            } else {
                pos = StringUtils.findBreakAfter(line, guess);
                if (pos != -1 && fm.stringWidth(before = line.substring(0, pos).trim()) > maxWidth) {
                    pos = StringUtils.findBreakBefore(line, guess);
                }
            }
            if (pos == -1) {
                pos = guess;
            }
            list.add(line.substring(0, pos).trim());
            line = line.substring(pos).trim();
            len = line.length();
        }
        if (len > 0) {
            list.add(line);
        }
    }

    public static int findBreakBefore(String line, int start) {
        for (int i = start; i >= 0; --i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static int findBreakAfter(String line, int start) {
        int len = line.length();
        for (int i = start; i < len; ++i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitIntoLines(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int len = str.length();
        if (len == 0) {
            strings.add("");
            return strings;
        }
        int lineStart = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\r') {
                int newlineLength = 1;
                if (i + 1 < len && str.charAt(i + 1) == '\n') {
                    newlineLength = 2;
                }
                strings.add(str.substring(lineStart, i));
                lineStart = i + newlineLength;
                if (newlineLength != 2) continue;
                ++i;
                continue;
            }
            if (c != '\n') continue;
            strings.add(str.substring(lineStart, i));
            lineStart = i + 1;
        }
        if (lineStart < len) {
            strings.add(str.substring(lineStart));
        }
        return strings;
    }

    public static AttributedString createFallbackString(String text, Font mainFont, Font fallbackFont) {
        AttributedString result = new AttributedString(text);
        int textLength = text.length();
        if (textLength == 0) {
            return new AttributedString("");
        }
        result.addAttribute(TextAttribute.FONT, mainFont, 0, textLength);
        boolean fallback = false;
        int fallbackBegin = 0;
        for (int i = 0; i < text.length(); ++i) {
            boolean curFallback;
            boolean bl = curFallback = !mainFont.canDisplay(text.charAt(i));
            if (curFallback == fallback) continue;
            System.out.println("curFallback = " + curFallback);
            System.out.println("fallbackFont = " + fallbackFont);
            fallback = curFallback;
            if (fallback) {
                fallbackBegin = i;
                continue;
            }
            result.addAttribute(TextAttribute.FONT, fallbackFont, fallbackBegin, i);
        }
        return result;
    }

    public static String join(List<String> strings, String s) {
        return String.join((CharSequence)s, strings);
    }
}

