/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.resources.v0;

import com.ultreon.libs.commons.v0.util.IOUtils;
import com.ultreon.libs.functions.v0.misc.ThrowingSupplier;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Resource {
    protected ThrowingSupplier<InputStream, IOException> opener;
    private byte[] data;
    private BufferedImage image;

    public Resource(ThrowingSupplier<InputStream, IOException> opener) {
        this.opener = opener;
    }

    public void load() {
        try (InputStream inputStream = (InputStream)this.opener.get();){
            this.data = IOUtils.readAllBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] loadOrGet() {
        if (this.data == null) {
            this.load();
        }
        return this.getData();
    }

    public InputStream loadOrOpenStream() {
        return new ByteArrayInputStream(this.loadOrGet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image loadImage() {
        try (InputStream inputStream = (InputStream)this.opener.get();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.loadOrGet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Font loadFont() throws FontFormatException {
        try (InputStream inputStream = (InputStream)this.opener.get();){
            Font font = Font.createFont(0, inputStream);
            return font;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedImage readImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        this.image = ImageIO.read(this.openStream());
        return this.image;
    }
}

