/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.text.v0;

import com.ultreon.libs.text.v0.AttributedStringBuilder;
import com.ultreon.libs.text.v0.FontWeight;
import com.ultreon.libs.text.v0.FontWidth;
import com.ultreon.libs.text.v0.TextObject;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public abstract class MutableText
extends TextObject {
    final List<TextObject> extras = new ArrayList<TextObject>();
    private final Map<AttributedCharacterIterator.Attribute, Object> attrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
    private Color color;

    @Override
    public AttributedString getAttrString() {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        String string = this.createString();
        if (!string.isEmpty()) {
            builder.append(new AttributedString(string, this.getAttrs()));
        }
        for (TextObject extra : this.extras) {
            builder.append(extra.getAttrString());
        }
        return builder.build();
    }

    @Override
    public final String getText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.createString());
        for (TextObject extra : this.extras) {
            builder.append(extra.getText());
        }
        return builder.toString();
    }

    public Color getColor() {
        return (Color)this.attrs.get(TextAttribute.FOREGROUND);
    }

    public MutableText setColor(Color color) {
        this.attrs.put(TextAttribute.FOREGROUND, color);
        return this;
    }

    public boolean isUnderlined() {
        return this.attrs.get(TextAttribute.UNDERLINE) != null;
    }

    public MutableText setUnderlined(boolean underlined) {
        this.attrs.put(TextAttribute.FOREGROUND, underlined ? TextAttribute.UNDERLINE_LOW_ONE_PIXEL : null);
        return this;
    }

    public boolean isStrikethrough() {
        return (Boolean)this.attrs.get(TextAttribute.STRIKETHROUGH);
    }

    public MutableText setStrikethrough(boolean strikethrough) {
        this.attrs.put(TextAttribute.STRIKETHROUGH, strikethrough);
        return this;
    }

    public boolean isLigaturesEnabled() {
        return Objects.equals(this.attrs.get(TextAttribute.LIGATURES), 1);
    }

    public MutableText setLigaturesEnabled(boolean ligaturesEnabled) {
        this.attrs.put(TextAttribute.LIGATURES, ligaturesEnabled ? 1 : 0);
        return this;
    }

    public double getSize() {
        return ((Number)this.attrs.get(TextAttribute.SIZE)).doubleValue();
    }

    public MutableText setSize(double size) {
        this.attrs.put(TextAttribute.SIZE, size);
        return this;
    }

    public float getWidth() {
        return ((Float)this.attrs.get(TextAttribute.SIZE)).floatValue();
    }

    public MutableText setWidth(float size) {
        this.attrs.put(TextAttribute.WIDTH, Float.valueOf(size));
        return this;
    }

    public FontWidth getFontWidth() {
        return FontWidth.closestTo(((Float)this.attrs.get(TextAttribute.SIZE)).floatValue());
    }

    public MutableText setFontWidth(FontWidth width) {
        this.attrs.put(TextAttribute.WIDTH, Float.valueOf(width.getWidth()));
        return this;
    }

    public float getWeight() {
        return ((Float)this.attrs.get(TextAttribute.WEIGHT)).floatValue();
    }

    public MutableText setWeight(float weight) {
        this.attrs.put(TextAttribute.WEIGHT, Float.valueOf(weight));
        return this;
    }

    @NotNull
    public FontWeight getFontWeight() {
        return FontWeight.closestTo(((Float)this.attrs.get(TextAttribute.WEIGHT)).floatValue());
    }

    public MutableText setFontWeight(@NotNull FontWeight weight) {
        this.attrs.put(TextAttribute.WEIGHT, Float.valueOf(weight.getWeight()));
        return this;
    }

    public @Range(from=-7L, to=7L) int getSuperscript() {
        return (Integer)this.attrs.get(TextAttribute.SUPERSCRIPT);
    }

    public MutableText setFontWeight(@Range(from=-7L, to=7L) int superscript) {
        this.attrs.put(TextAttribute.SUPERSCRIPT, superscript);
        return this;
    }

    public Map<? extends AttributedCharacterIterator.Attribute, ?> getAttrs() {
        return this.attrs;
    }

    public MutableText append(TextObject textObject) {
        this.extras.add(textObject);
        return this;
    }

    public MutableText append(String text) {
        this.extras.add(TextObject.nullToEmpty(text));
        return this;
    }

    public MutableText append(Object o) {
        this.extras.add(TextObject.nullToEmpty(String.valueOf(o)));
        return this;
    }
}

