/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5.stream;

import de.marhali.json5.Json5Array;
import de.marhali.json5.Json5Element;
import de.marhali.json5.Json5Object;
import de.marhali.json5.Json5Options;
import de.marhali.json5.Json5Primitive;
import de.marhali.json5.Json5String;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Json5Writer {
    private final Json5Options options;
    private final Writer writer;

    public Json5Writer(Json5Options options, Writer writer) {
        this.options = Objects.requireNonNull(options);
        this.writer = Objects.requireNonNull(writer);
    }

    public void write(Json5Element element) throws IOException {
        this.write(element, "");
    }

    public void write(Json5Element element, String indent) throws IOException {
        Objects.requireNonNull(element);
        Objects.requireNonNull(indent);
        if (element.isJson5Null()) {
            this.writeNull();
        } else if (element.isJson5Object()) {
            this.writeObject(element.getAsJson5Object(), indent);
        } else if (element.isJson5Array()) {
            this.writeArray(element.getAsJson5Array(), indent);
        } else if (element.isJson5Primitive()) {
            this.writePrimitive(element.getAsJson5Primitive());
        } else {
            throw new UnsupportedOperationException("Unknown json element with type class " + element.getClass().getName());
        }
    }

    public void writeNull() throws IOException {
        this.writer.write("null");
    }

    public void writePrimitive(Json5Primitive primitive) throws IOException {
        Objects.requireNonNull(primitive);
        if (primitive instanceof Json5String) {
            this.writer.append(this.quote(primitive.getAsString()));
        } else {
            this.writer.append(primitive.getAsString());
        }
    }

    public void writeObject(Json5Object object, String indent) throws IOException {
        Objects.requireNonNull(object);
        Objects.requireNonNull(indent);
        String childIndent = indent + " ".repeat(this.options.getIndentFactor());
        this.writer.write("{");
        int index = 0;
        for (Map.Entry<String, Json5Element> entry : object.entrySet()) {
            String comment;
            if (this.options.getIndentFactor() > 0) {
                this.writer.append('\n').append(childIndent);
            }
            if ((comment = object.getComment(entry.getKey())) != null && this.options.getIndentFactor() > 0) {
                List<String> lines = comment.lines().toList();
                for (String line : lines) {
                    this.writer.append("// ").append(line).append('\n').append(childIndent);
                }
            } else if (comment != null) {
                this.writer.append("/* ").append(comment).append(" */");
            }
            if (this.options.isQuoteless() && entry.getKey().matches("^[a-zA-Z_][a-zA-Z0-9_]*[a-zA-Z_]$")) {
                this.writer.append(entry.getKey()).append(":");
            } else {
                this.writer.append(this.quote(entry.getKey())).append(":");
            }
            if (this.options.getIndentFactor() > 0) {
                this.writer.append(' ');
            }
            this.write(entry.getValue(), childIndent);
            if (this.options.isTrailingComma() || index < object.size() - 1) {
                this.writer.append(',');
            }
            ++index;
        }
        if (this.options.getIndentFactor() > 0 && object.size() > 0) {
            this.writer.append('\n').append(indent);
        }
        this.writer.append('}');
    }

    public void writeArray(Json5Array array, String indent) throws IOException {
        Objects.requireNonNull(array);
        Objects.requireNonNull(indent);
        String childIndent = indent + " ".repeat(this.options.getIndentFactor());
        this.writer.write(91);
        for (int i = 0; i < array.size(); ++i) {
            Json5Element currentElement = array.get(i);
            if (this.options.getIndentFactor() > 0) {
                this.writer.append('\n').append(childIndent);
            }
            this.write(currentElement, childIndent);
            if (!this.options.isTrailingComma() && i >= array.size() - 1) continue;
            this.writer.append(',');
        }
        if (this.options.getIndentFactor() > 0 && !array.isEmpty()) {
            this.writer.append('\n').append(indent);
        }
        this.writer.write(93);
    }

    public String quote(String string) {
        char qt;
        char c = qt = this.options.isQuoteSingle() ? (char)'\'' : '\"';
        if (string == null || string.isEmpty()) {
            return String.valueOf(qt).repeat(2);
        }
        StringBuilder quoted = new StringBuilder(string.length() + 2);
        quoted.append(qt);
        block12: for (char c2 : string.toCharArray()) {
            if (c2 == qt) {
                quoted.append('\\');
                quoted.append(c2);
                continue;
            }
            switch (c2) {
                case '\\': {
                    quoted.append("\\\\");
                    continue block12;
                }
                case '\b': {
                    quoted.append("\\b");
                    continue block12;
                }
                case '\f': {
                    quoted.append("\\f");
                    continue block12;
                }
                case '\n': {
                    quoted.append("\\n");
                    continue block12;
                }
                case '\r': {
                    quoted.append("\\r");
                    continue block12;
                }
                case '\t': {
                    quoted.append("\\t");
                    continue block12;
                }
                case '\u000b': {
                    quoted.append("\\v");
                    continue block12;
                }
                default: {
                    switch (Character.getType(c2)) {
                        case 0: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: {
                            quoted.append("\\u");
                            quoted.append(String.format("%04X", Character.valueOf(c2)));
                            continue block12;
                        }
                    }
                    quoted.append(c2);
                }
            }
        }
        quoted.append(qt);
        return quoted.toString();
    }
}

