/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5.stream;

import de.marhali.json5.Json5Boolean;
import de.marhali.json5.Json5Element;
import de.marhali.json5.Json5Hexadecimal;
import de.marhali.json5.Json5Null;
import de.marhali.json5.Json5Number;
import de.marhali.json5.Json5Options;
import de.marhali.json5.Json5String;
import de.marhali.json5.exception.Json5Exception;
import de.marhali.json5.stream.Json5Parser;
import java.io.BufferedReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Pattern;

public class Json5Lexer {
    private static final Pattern PATTERN_BOOLEAN = Pattern.compile("true|false");
    private static final Pattern PATTERN_NUMBER_FLOAT = Pattern.compile("[+-]?((0|[1-9]\\d*)(\\.\\d*)?|\\.\\d+)([eE][+-]?\\d+)?");
    private static final Pattern PATTERN_NUMBER_INTEGER = Pattern.compile("[+-]?(0|[1-9]\\d*)");
    private static final Pattern PATTERN_NUMBER_HEX = Pattern.compile("[+-]?0[xX][0-9a-fA-F]+");
    private static final Pattern PATTERN_NUMBER_SPECIAL = Pattern.compile("[+-]?(Infinity|NaN)");
    private final Reader reader;
    private final Json5Options options;
    private boolean eof;
    private boolean back;
    private long index;
    private long character;
    private long line;
    private char previous;
    private char current;

    public Json5Lexer(Reader reader, Json5Options options) {
        this.reader = Objects.requireNonNull(reader).markSupported() ? reader : new BufferedReader(reader);
        this.options = Objects.requireNonNull(options);
        this.eof = false;
        this.back = false;
        this.index = -1L;
        this.character = 0L;
        this.line = 1L;
        this.previous = '\u0000';
        this.current = '\u0000';
    }

    private boolean more() {
        if (this.back || this.eof) {
            return this.back && !this.eof;
        }
        return this.peek() > '\u0000';
    }

    public void back() {
        this.back = true;
    }

    private char peek() {
        int c;
        if (this.eof) {
            return '\u0000';
        }
        try {
            this.reader.mark(1);
            c = this.reader.read();
            this.reader.reset();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not peek from source", e);
        }
        return c == -1 ? (char)'\u0000' : (char)c;
    }

    private char next() {
        int c;
        if (this.back) {
            this.back = false;
            return this.current;
        }
        try {
            c = this.reader.read();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not read from source", e);
        }
        if (c < 0) {
            this.eof = true;
            return '\u0000';
        }
        this.previous = this.current;
        this.current = (char)c;
        ++this.index;
        if (this.isLineTerminator(this.current) && (this.current != '\n' || this.current == '\n' && this.previous != '\r')) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        return this.current;
    }

    private boolean isLineTerminator(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u2028': 
            case '\u2029': 
            case '\ufeff': {
                return true;
            }
        }
        return Character.getType(c) == 12;
    }

    private boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private void nextMultiLineComment() {
        char n;
        while ((n = this.next()) != '*' || this.peek() != '/') {
        }
        this.next();
    }

    private void nextSingleLineComment() {
        char n;
        while (!this.isLineTerminator(n = this.next()) && n != '\u0000') {
        }
    }

    public char nextClean() {
        char n;
        while (true) {
            if (!this.more()) {
                if (this.index == -1L) {
                    return '\u0000';
                }
                throw this.syntaxError("Unexpected end of data");
            }
            n = this.next();
            if (n == '/') {
                char p = this.peek();
                if (p == '*') {
                    this.next();
                    this.nextMultiLineComment();
                    continue;
                }
                if (p == '/') {
                    this.next();
                    this.nextSingleLineComment();
                    continue;
                }
                return n;
            }
            if (!this.isWhitespace(n)) break;
        }
        return n;
    }

    private String nextCleanTo(String delimiters) {
        StringBuilder result = new StringBuilder();
        while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            char n = this.nextClean();
            if (delimiters.indexOf(n) > -1 || this.isWhitespace(n)) break;
            result.append(n);
        }
        this.back();
        return result.toString();
    }

    private int dehex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private char unicodeEscape(boolean member, boolean part) {
        String where = member ? "key" : "string";
        Object value = "";
        int codepoint = 0;
        for (int i = 0; i < 4; ++i) {
            char n = this.next();
            value = (String)value + n;
            int hex = this.dehex(n);
            if (hex == -1) {
                throw this.syntaxError("Illegal unicode escape sequence '\\u" + (String)value + "' in " + where);
            }
            codepoint |= hex << (3 - i << 2);
        }
        if (member && !this.isMemberNameChar((char)codepoint, part)) {
            throw this.syntaxError("Illegal unicode escape sequence '\\u" + (String)value + "' in key");
        }
        return (char)codepoint;
    }

    private void checkSurrogate(char hi, char lo) {
        if (this.options.isAllowInvalidSurrogates()) {
            return;
        }
        if (!Character.isHighSurrogate(hi) || !Character.isLowSurrogate(lo)) {
            return;
        }
        if (!Character.isSurrogatePair(hi, lo)) {
            throw this.syntaxError(String.format("Invalid surrogate pair: U+%04X and U+%04X", Character.valueOf(hi), Character.valueOf(lo)));
        }
    }

    private String nextString(char quote) {
        StringBuilder result = new StringBuilder();
        char n = '\u0000';
        block12: while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            char prev = n;
            n = this.next();
            if (n == quote) break;
            if (this.isLineTerminator(n) && n != '\u2028' && n != '\u2029') {
                throw this.syntaxError("Unescaped line terminator in string");
            }
            if (n == '\\') {
                n = this.next();
                if (this.isLineTerminator(n)) {
                    if (n != '\r' || this.peek() != '\n') continue;
                    this.next();
                    continue;
                }
                switch (n) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(n);
                        continue block12;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block12;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block12;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block12;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block12;
                    }
                    case 't': {
                        result.append('\t');
                        continue block12;
                    }
                    case 'v': {
                        result.append('\u000b');
                        continue block12;
                    }
                    case '0': {
                        char p = this.peek();
                        if (this.isDecimalDigit(p)) {
                            throw this.syntaxError("Illegal escape sequence '\\0" + p + "'");
                        }
                        result.append('\u0000');
                        continue block12;
                    }
                    case 'x': {
                        Object value = "";
                        int codepoint = 0;
                        for (int i = 0; i < 2; ++i) {
                            n = this.next();
                            value = (String)value + n;
                            int hex = this.dehex(n);
                            if (hex == -1) {
                                throw this.syntaxError("Illegal hex escape sequence '\\x" + (String)value + "' in string");
                            }
                            codepoint |= hex << (1 - i << 2);
                        }
                        n = (char)codepoint;
                        break;
                    }
                    case 'u': {
                        n = this.unicodeEscape(false, false);
                        break;
                    }
                    default: {
                        if (!this.isDecimalDigit(n)) break;
                        throw this.syntaxError("Illegal escape sequence '\\" + n + "'");
                    }
                }
            }
            this.checkSurrogate(prev, n);
            result.append(n);
        }
        return result.toString();
    }

    private boolean isMemberNameChar(char n, boolean part) {
        if (n == '$' || n == '_' || n == '\u200c' || n == '\u200d') {
            return true;
        }
        int type = Character.getType(n);
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
            case 6: 
            case 8: 
            case 9: 
            case 23: {
                if (!part) break;
                return true;
            }
        }
        return false;
    }

    public String nextMemberName() {
        StringBuilder result = new StringBuilder();
        char n = this.next();
        if (n == '\"' || n == '\'') {
            return this.nextString(n);
        }
        this.back();
        n = '\u0000';
        while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            boolean part = result.length() > 0;
            char prev = n;
            n = this.next();
            if (n == '\\') {
                n = this.next();
                if (n != 'u') {
                    throw this.syntaxError("Illegal escape sequence '\\" + n + "' in key");
                }
                n = this.unicodeEscape(true, part);
            } else if (!this.isMemberNameChar(n, part)) break;
            this.checkSurrogate(prev, n);
            result.append(n);
        }
        this.back();
        if (result.length() == 0) {
            throw this.syntaxError("Empty key");
        }
        return result.toString();
    }

    public Json5Element nextValue() {
        char n = this.nextClean();
        switch (n) {
            case '\"': 
            case '\'': {
                String string = this.nextString(n);
                return new Json5String(string);
            }
            case '{': {
                this.back();
                return Json5Parser.parseObject(this);
            }
            case '[': {
                this.back();
                return Json5Parser.parseArray(this);
            }
        }
        this.back();
        String string = this.nextCleanTo(",]}");
        if (string.equals("null")) {
            return Json5Null.INSTANCE;
        }
        if (PATTERN_BOOLEAN.matcher(string).matches()) {
            return new Json5Boolean(string.equals("true"));
        }
        if (PATTERN_NUMBER_INTEGER.matcher(string).matches()) {
            BigInteger bigint = new BigInteger(string);
            return new Json5Number(bigint);
        }
        if (PATTERN_NUMBER_FLOAT.matcher(string).matches()) {
            return new Json5Number(new BigDecimal(string));
        }
        if (PATTERN_NUMBER_SPECIAL.matcher(string).matches()) {
            String special;
            double d = 0.0;
            int factor = switch (string.charAt(0)) {
                case '+' -> {
                    special = string.substring(1);
                    yield 1;
                }
                case '-' -> {
                    special = string.substring(1);
                    yield -1;
                }
                default -> {
                    special = string;
                    yield 1;
                }
            };
            switch (special) {
                case "NaN": {
                    d = Double.NaN;
                    break;
                }
                case "Infinity": {
                    d = Double.POSITIVE_INFINITY;
                }
            }
            return new Json5Number((double)factor * d);
        }
        if (PATTERN_NUMBER_HEX.matcher(string).matches()) {
            return new Json5Hexadecimal(string);
        }
        throw new Json5Exception("Illegal value '" + string + "'");
    }

    protected Json5Exception syntaxError(String message, Throwable cause) {
        return new Json5Exception(message + this, cause);
    }

    protected Json5Exception syntaxError(String message) {
        return new Json5Exception(message + this);
    }

    public String toString() {
        return " at index " + this.index + " [character " + this.character + " in line " + this.line + "]";
    }
}

