/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5;

import de.marhali.json5.Json5Primitive;
import java.math.BigInteger;
import java.util.Objects;

public final class Json5Hexadecimal
extends Json5Primitive {
    public static BigInteger parseHexString(String hex) {
        Objects.requireNonNull(hex);
        switch (hex.charAt(0)) {
            case '+': {
                return new BigInteger(hex.substring(3), 16);
            }
            case '-': {
                return new BigInteger(hex.substring(3), 16).negate();
            }
        }
        return new BigInteger(hex.substring(2), 16);
    }

    public static String serializeHexString(BigInteger bigInteger, boolean prefixPositive) {
        Objects.requireNonNull(bigInteger);
        if (bigInteger.signum() >= 0) {
            return (prefixPositive ? "+0x" : "0x") + bigInteger.toString(16);
        }
        return "-0x" + bigInteger.abs().toString(16);
    }

    public Json5Hexadecimal(BigInteger hex) {
        super(hex);
    }

    public Json5Hexadecimal(String hex) {
        super(Json5Hexadecimal.parseHexString(hex));
    }

    @Override
    public String getAsString() {
        return Json5Hexadecimal.serializeHexString(super.getAsBigInteger(), false);
    }
}

