/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5;

import de.marhali.json5.Json5Boolean;
import de.marhali.json5.Json5Element;
import de.marhali.json5.Json5Null;
import de.marhali.json5.Json5Number;
import de.marhali.json5.Json5String;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Json5Array
extends Json5Element
implements Iterable<Json5Element> {
    private final List<Json5Element> elements;

    public Json5Array() {
        this.elements = new ArrayList<Json5Element>();
    }

    public Json5Array(int capacity) {
        this.elements = new ArrayList<Json5Element>(capacity);
    }

    @Override
    public Json5Array deepCopy() {
        if (!this.elements.isEmpty()) {
            Json5Array result = new Json5Array(this.elements.size());
            for (Json5Element element : this.elements) {
                result.add(element.deepCopy());
            }
            return result;
        }
        return new Json5Array();
    }

    public void add(Boolean bool) {
        this.elements.add(bool == null ? Json5Null.INSTANCE : new Json5Boolean(bool));
    }

    public void add(Character character) {
        this.elements.add(character == null ? Json5Null.INSTANCE : new Json5String(character.toString()));
    }

    public void add(Number number) {
        this.elements.add(number == null ? Json5Null.INSTANCE : new Json5Number(number));
    }

    public void add(String string) {
        this.elements.add(string == null ? Json5Null.INSTANCE : new Json5String(string));
    }

    public void add(Json5Element element) {
        if (element == null) {
            element = Json5Null.INSTANCE;
        }
        this.elements.add(element);
    }

    public void addAll(Json5Array array) {
        this.elements.addAll(array.elements);
    }

    public Json5Element set(int index, Json5Element element) {
        return this.elements.set(index, element);
    }

    public boolean remove(Json5Element element) {
        return this.elements.remove(element);
    }

    public Json5Element remove(int index) {
        return this.elements.remove(index);
    }

    public boolean contains(Json5Element element) {
        return this.elements.contains(element);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<Json5Element> iterator() {
        return this.elements.iterator();
    }

    public Json5Element get(int i) {
        return this.elements.get(i);
    }

    @Override
    public Number getAsNumber() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsNumber();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAsString() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsString();
        }
        throw new IllegalStateException();
    }

    @Override
    public double getAsDouble() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsDouble();
        }
        throw new IllegalStateException();
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsBigDecimal();
        }
        throw new IllegalStateException();
    }

    @Override
    public BigInteger getAsBigInteger() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsBigInteger();
        }
        throw new IllegalStateException();
    }

    @Override
    public float getAsFloat() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsFloat();
        }
        throw new IllegalStateException();
    }

    @Override
    public long getAsLong() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsLong();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getAsInt() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsInt();
        }
        throw new IllegalStateException();
    }

    @Override
    public byte getAsByte() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsByte();
        }
        throw new IllegalStateException();
    }

    @Override
    public short getAsShort() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsShort();
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean getAsBoolean() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).getAsBoolean();
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Json5Array && ((Json5Array)o).elements.equals(this.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

