/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.datetime.v0;

import com.ultreon.libs.datetime.v0.Time;

public enum DayPeriod {
    NIGHT(new Time(0, 0, 0), new Time(6, 0, 0)),
    MORNING(new Time(6, 0, 0), new Time(12, 0, 0)),
    AFTERNOON(new Time(12, 0, 0), new Time(18, 0, 0)),
    EVENING(new Time(18, 0, 0), new Time(0, 0, 0));

    private final Time start;
    private final Time end;

    private DayPeriod(Time startInclusive, Time endExclusive) {
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public Time getStart() {
        return this.start;
    }

    public Time getEnd() {
        return this.end;
    }

    public boolean isWithin(Time time) {
        switch (this) {
            case EVENING: {
                return time.isAfterOrEqual(this.start);
            }
            case NIGHT: {
                return time.isBefore(this.end);
            }
        }
        return time.isAfterOrEqual(this.start) && time.isBefore(this.end);
    }
}

