/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Objects;

public class BitSetType
implements IType<BitSet> {
    private BitSet obj;

    public BitSetType(byte[] bits) {
        this.obj = BitSet.valueOf(bits);
    }

    public BitSetType(long[] bits) {
        this.obj = BitSet.valueOf(bits);
    }

    public BitSetType(BitSet obj) {
        this.obj = obj;
    }

    public BitSetType(String bits) {
        this.obj = new BitSet(bits.length());
        for (int i = 0; i < bits.length(); ++i) {
            this.obj.set(i, bits.charAt(i) == '1');
        }
    }

    @Override
    public BitSet getValue() {
        return this.obj;
    }

    @Override
    public void setValue(BitSet obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj;
    }

    @Override
    public int id() {
        return Types.BIT_SET;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        byte[] arr = this.obj.toByteArray();
        if (arr.length >= 32768) {
            throw new IllegalArgumentException("Bitset is too big to be written");
        }
        stream.writeShort(arr.length);
        for (byte b : arr) {
            stream.writeByte(b);
        }
    }

    public static BitSetType read(DataInputStream stream) throws IOException {
        int len = stream.readShort();
        byte[] arr = new byte[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = stream.readByte();
        }
        return new BitSetType(arr);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitSetType)) {
            return false;
        }
        BitSetType uuidType = (BitSetType)other;
        return Objects.equals(this.obj, uuidType.obj);
    }

    @Override
    public int hashCode() {
        return this.obj.hashCode();
    }

    public BitSetType copy() {
        return new BitSetType((BitSet)this.obj.clone());
    }

    @Override
    public String writeUso() {
        StringBuilder builder = new StringBuilder("x");
        for (int i = 0; i < this.obj.length(); ++i) {
            builder.append(this.obj.get(i) ? "1" : "0");
        }
        return builder + ";";
    }

    public void setBit(int index, boolean value) {
        if (value) {
            this.obj.set(index);
        } else {
            this.obj.clear(index);
        }
    }

    public boolean getBit(int index) {
        return this.obj.get(index);
    }

    public int length() {
        return this.obj.length();
    }

    public int cardinality() {
        return this.obj.cardinality();
    }

    public int nextSetBit(int fromIndex) {
        return this.obj.nextSetBit(fromIndex);
    }

    public int nextClearBit(int fromIndex) {
        return this.obj.nextClearBit(fromIndex);
    }

    public int previousSetBit(int fromIndex) {
        return this.obj.previousSetBit(fromIndex);
    }

    public int previousClearBit(int fromIndex) {
        return this.obj.previousClearBit(fromIndex);
    }

    public String toString() {
        return this.writeUso();
    }
}

