/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data;

import com.ultreon.data.types.BigDecType;
import com.ultreon.data.types.BigIntType;
import com.ultreon.data.types.BitSetType;
import com.ultreon.data.types.BooleanType;
import com.ultreon.data.types.ByteArrayType;
import com.ultreon.data.types.ByteType;
import com.ultreon.data.types.CharArrayType;
import com.ultreon.data.types.CharType;
import com.ultreon.data.types.DoubleArrayType;
import com.ultreon.data.types.DoubleType;
import com.ultreon.data.types.FloatArrayType;
import com.ultreon.data.types.FloatType;
import com.ultreon.data.types.IType;
import com.ultreon.data.types.IntArrayType;
import com.ultreon.data.types.IntType;
import com.ultreon.data.types.ListType;
import com.ultreon.data.types.LongArrayType;
import com.ultreon.data.types.LongType;
import com.ultreon.data.types.MapType;
import com.ultreon.data.types.ShortArrayType;
import com.ultreon.data.types.ShortType;
import com.ultreon.data.types.StringType;
import com.ultreon.data.types.UUIDType;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.UUID;

public class UsoParser {
    private final String input;
    private final char[] chars;
    private int pos;
    private char c;

    public UsoParser(String input) {
        this.input = input;
        this.chars = input.toCharArray();
    }

    private IType<?> readUso() throws IOException {
        int read = this.read();
        switch (read) {
            case 91: {
                return this.readList();
            }
            case 123: {
                return this.readMap();
            }
            case 40: {
                return this.readArray();
            }
            case 60: {
                return this.readUUID();
            }
            case 34: {
                return this.readString();
            }
            case 39: {
                return new CharType(this.readChar());
            }
            case 120: {
                return this.readBitSet();
            }
            case 102: 
            case 116: {
                this.unread();
                return this.readBoolean();
            }
        }
        if (Character.isDigit(read)) {
            return this.readNumber(read);
        }
        throw new IOException("Invalid USO: " + (char)read);
    }

    private IType<?> readBoolean() throws IOException {
        int r;
        StringBuilder builder = new StringBuilder();
        while ((r = this.read()) != -1 && Character.isAlphabetic(r)) {
            builder.append((char)r);
        }
        this.unread();
        String string = builder.toString();
        if (string.equalsIgnoreCase("true")) {
            return new BooleanType(true);
        }
        if (string.equalsIgnoreCase("false")) {
            return new BooleanType(false);
        }
        throw new IOException("Invalid boolean: " + string);
    }

    private IType<?> readArray() throws IOException {
        int read = this.read();
        switch ((char)read) {
            case 'b': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readByteArray();
            }
            case 's': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readShortArray();
            }
            case 'i': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readIntArray();
            }
            case 'l': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readLongArray();
            }
            case 'f': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readFloatArray();
            }
            case 'd': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readDoubleArray();
            }
            case 'B': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readBitSet();
            }
            case 'c': {
                if (this.read() != 59) {
                    throw new IOException("Invalid array: expected ';'");
                }
                return this.readCharArray();
            }
        }
        throw new IOException("Invalid array");
    }

    private CharArrayType readCharArray() throws IOException {
        int r;
        char[] chars = new char[]{};
        do {
            if ((r = this.read()) == -1) {
                throw new EOFException("Invalid character: EOF");
            }
            if (r != 39) {
                throw new IOException("Invalid character: expected ' but got " + (char)r);
            }
            char c = this.readChar();
            r = this.read();
            chars = this.add(chars, c);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected , or ) but got " + (char)r);
        }
        return new CharArrayType(chars);
    }

    private ByteArrayType readByteArray() throws IOException {
        int r;
        byte[] bytes = new byte[]{};
        do {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            while (true) {
                r = this.read();
                if (first && r == 45) {
                    builder.append((char)r);
                    first = false;
                    continue;
                }
                if (!Character.isDigit(r)) break;
                builder.append((char)r);
                first = false;
            }
            if (r == -1) {
                throw new IOException("Invalid number");
            }
            byte number = Byte.parseByte(builder.toString());
            bytes = this.add(bytes, number);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected ',' or ')' but got " + (char)r);
        }
        return new ByteArrayType(bytes);
    }

    private ShortArrayType readShortArray() throws IOException {
        int r;
        short[] shorts = new short[]{};
        do {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            while (true) {
                r = this.read();
                if (first && r == 45) {
                    builder.append((char)r);
                    first = false;
                    continue;
                }
                if (!Character.isDigit(r)) break;
                builder.append((char)r);
            }
            if (r == -1) {
                throw new IOException("Invalid number");
            }
            short number = Short.parseShort(builder.toString());
            shorts = this.add(shorts, number);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected ',' or ')' but got " + (char)r);
        }
        return new ShortArrayType(shorts);
    }

    private IntArrayType readIntArray() throws IOException {
        int r;
        int[] ints = new int[]{};
        do {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            while (true) {
                r = this.read();
                if (first && r == 45) {
                    builder.append((char)r);
                    first = false;
                    continue;
                }
                if (!Character.isDigit(r)) break;
                builder.append((char)r);
            }
            if (r == -1) {
                throw new IOException("Invalid number");
            }
            int number = Integer.parseInt(builder.toString());
            ints = this.add(ints, number);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected ',' or ')' but got " + (char)r);
        }
        return new IntArrayType(ints);
    }

    private LongArrayType readLongArray() throws IOException {
        int r;
        long[] longs = new long[]{};
        do {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            while (true) {
                r = this.read();
                if (first && r == 45) {
                    builder.append((char)r);
                    first = false;
                    continue;
                }
                if (!Character.isDigit(r)) break;
                builder.append((char)r);
            }
            if (r == -1) {
                throw new IOException("Invalid number");
            }
            long number = Long.parseLong(builder.toString());
            longs = this.add(longs, number);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected ',' or ')' but got " + (char)r);
        }
        return new LongArrayType(longs);
    }

    private FloatArrayType readFloatArray() throws IOException {
        int r;
        float[] floats = new float[]{};
        do {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            while (true) {
                r = this.read();
                if (first && r == 45) {
                    builder.append((char)r);
                    first = false;
                    continue;
                }
                if (!Character.isDigit(r) && r != 46) break;
                builder.append((char)r);
            }
            if (r == -1) {
                throw new IOException("Invalid number");
            }
            float number = Float.parseFloat(builder.toString());
            floats = this.add(floats, number);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected ',' or ')' but got " + (char)r);
        }
        return new FloatArrayType(floats);
    }

    private DoubleArrayType readDoubleArray() throws IOException {
        int r;
        double[] doubles = new double[]{};
        do {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            while (true) {
                r = this.read();
                if (first && r == 45) {
                    builder.append((char)r);
                    first = false;
                    continue;
                }
                if (!Character.isDigit(r) && r != 46) break;
                builder.append((char)r);
            }
            if (r == -1) {
                throw new IOException("Invalid number");
            }
            double number = Double.parseDouble(builder.toString());
            doubles = this.add(doubles, number);
        } while (r == 44);
        if (r != 41) {
            throw new IOException("Invalid array: expected ',' or ')' but got " + (char)r);
        }
        return new DoubleArrayType(doubles);
    }

    private char readChar() throws IOException {
        int read = this.read();
        if (read == 92) {
            read = this.read();
            if (read == 116) {
                read = 9;
            } else if (read == 110) {
                read = 10;
            } else if (read == 114) {
                read = 13;
            } else if (read == 98) {
                read = 8;
            } else if (read == 102) {
                read = 12;
            } else if (read == 48) {
                read = 0;
            } else if (read == 117) {
                read = this.read();
                read = (read << 4) + this.read();
                read = (read << 4) + this.read();
                read = (read << 4) + this.read();
            }
        } else if (read == -1) {
            throw new EOFException("Invalid char: reached end of stream");
        }
        if (this.read() != 39) {
            throw new IOException("Invalid char: expected ' but got " + (char)read);
        }
        return (char)read;
    }

    private byte[] add(byte[] bytes, byte number) {
        byte[] newBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private short[] add(short[] bytes, short number) {
        short[] newBytes = new short[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private int[] add(int[] bytes, int number) {
        int[] newBytes = new int[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private long[] add(long[] bytes, long number) {
        long[] newBytes = new long[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private float[] add(float[] bytes, float number) {
        float[] newBytes = new float[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private double[] add(double[] bytes, double number) {
        double[] newBytes = new double[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private char[] add(char[] bytes, char number) {
        char[] newBytes = new char[bytes.length + 1];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        newBytes[bytes.length] = number;
        return newBytes;
    }

    private BitSetType readBitSet() throws IOException {
        BitSet set = new BitSet();
        int i = 0;
        block6: while (true) {
            int read = this.read();
            switch (read) {
                case 48: {
                    set.clear(i);
                    break;
                }
                case 49: {
                    set.set(i);
                    break;
                }
                case 59: {
                    break block6;
                }
                case -1: {
                    throw new EOFException("Invalid bitset: EOF");
                }
                default: {
                    throw new IOException("Invalid bitset: expected '0', '1' or ';', got " + (char)read);
                }
            }
            ++i;
        }
        return new BitSetType(set);
    }

    private IType<?> readNumber(int read) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append((char)read);
        while (Character.isDigit(read = this.read()) || read == 46) {
            builder.append((char)read);
        }
        if (read == -1) {
            throw new IOException("Invalid number");
        }
        switch ((char)read) {
            case 'b': {
                return new ByteType(Byte.parseByte(builder.toString()));
            }
            case 's': {
                return new ShortType(Short.parseShort(builder.toString()));
            }
            case 'i': {
                return new IntType(Integer.parseInt(builder.toString()));
            }
            case 'l': {
                return new LongType(Long.parseLong(builder.toString()));
            }
            case 'f': {
                return new FloatType(Float.parseFloat(builder.toString()));
            }
            case 'd': {
                return new DoubleType(Double.parseDouble(builder.toString()));
            }
            case 'I': {
                return new BigIntType(new BigInteger(builder.toString()));
            }
            case 'D': {
                return new BigDecType(new BigDecimal(builder.toString()));
            }
        }
        throw new IOException("Invalid number");
    }

    private IType<?> readList() throws IOException {
        IType<?> iType = this.readUso();
        if (iType == null) {
            throw new IOException("Invalid list: expected at least one element");
        }
        int id = iType.id();
        int read = this.read();
        if (read == 93) {
            ListType list = new ListType(id);
            list.add(iType);
            return list;
        }
        if (read != 44) {
            throw new IOException("Invalid list: expected ',' or ']'");
        }
        this.readWhitespace();
        ListType list = new ListType(id);
        list.add(iType);
        while (true) {
            IType<?> cur;
            if ((cur = this.readUso()) == null) {
                throw new IOException("Invalid list: invalid element at index " + list.size());
            }
            if (cur.id() != id) {
                throw new IOException("Invalid list, ID mismatch: should be " + id + " but was " + cur.id());
            }
            list.add(cur);
            this.readWhitespace();
            read = this.read();
            if (read != 44) break;
            this.readWhitespace();
            read = this.read();
            if (read == 93) {
                return list;
            }
            this.unread();
        }
        if (read == 93) {
            return list;
        }
        throw new IOException("Invalid list: expected ',' or ']' but got " + (char)read);
    }

    private IType<?> readMap() throws IOException {
        MapType map = new MapType();
        int read = this.read();
        while (read != 125) {
            if (read != 34) {
                throw new IOException("Invalid map: expected '\"' but got " + (char)read);
            }
            StringType key = this.readString();
            this.readWhitespace();
            if (this.read() != 58) {
                throw new IOException("Invalid map: expected ':' but got " + (char)read);
            }
            this.read();
            this.readWhitespace();
            IType<?> value = this.readUso();
            map.put(key.getValue(), value);
            this.readWhitespace();
            read = this.read();
            if (read == 44) {
                this.readWhitespace();
                read = this.read();
                if (read != 125) continue;
                this.read();
                break;
            }
            if (read == 125) break;
            throw new IOException("Invalid map: expected ',' or '}' but got " + (char)read);
        }
        return map;
    }

    private StringType readString() {
        StringBuilder builder = new StringBuilder();
        int read = this.read();
        while (read != 34) {
            builder.append((char)read);
            if (read == 92) {
                read = this.read();
                if (read == 110) {
                    builder.append('\n');
                } else if (read == 114) {
                    builder.append('\r');
                } else if (read == 116) {
                    builder.append('\t');
                } else if (read == 98) {
                    builder.append('\b');
                } else if (read == 102) {
                    builder.append('\f');
                } else if (read == 48) {
                    builder.append('\u0000');
                } else if (read == 117) {
                    builder.append((char)(this.read() << 12 | this.read() << 8 | this.read() << 4 | this.read()));
                } else {
                    builder.append((char)read);
                }
            }
            read = this.read();
        }
        return new StringType(builder.toString());
    }

    private void readWhitespace() {
        int read;
        while (Character.isWhitespace(read = this.read())) {
        }
        this.unread();
    }

    private UUIDType readUUID() throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        while ((read = this.read()) != 62) {
            if (read == -1) {
                throw new EOFException("Invalid UUID: EOF");
            }
            if (Character.isWhitespace(read)) continue;
            builder.append((char)read);
        }
        try {
            return new UUIDType(UUID.fromString(builder.toString()));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid UUID: " + builder, e);
        }
    }

    private int unread() {
        if (this.pos <= 0) {
            return -1;
        }
        this.c = this.chars[--this.pos];
        return this.c;
    }

    private int read() {
        if (this.pos >= this.chars.length) {
            return -1;
        }
        this.c = this.chars[this.pos++];
        return this.c;
    }

    public IType<?> parse() throws IOException {
        try {
            return this.readUso();
        }
        catch (Exception e) {
            throw new IOException("Unable to parse USO at pos " + this.pos + ": " + e.getMessage(), e);
        }
    }
}

