/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0.util;

import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class EnumUtils {
    private EnumUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <E extends Enum<E>> E byIndex(int value, E defaultValue, Function<E, Integer> getter) {
        for (Enum e : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (getter.apply(e) != value) continue;
            return (E)e;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E byName(String name, E defaultValue) {
        for (Enum e : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return (E)e;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E byOrdinal(int ordinal, E defaultValue) {
        Enum[] enumConstants = (Enum[])defaultValue.getDeclaringClass().getEnumConstants();
        if (ordinal >= 0 && ordinal < enumConstants.length) {
            return (E)enumConstants[ordinal];
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> boolean validate(@Nullable Object obj, Class<E> enumClass) {
        if (obj != null) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(obj.toString())) continue;
                return true;
            }
        }
        return false;
    }
}

