/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0.platform.win32;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Objects;

public final class AlternateDataStream {
    private final File file;
    private final String id;

    public AlternateDataStream(File file, String id) {
        this.file = file;
        this.id = id;
    }

    public File file() {
        return this.file;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AlternateDataStream that = (AlternateDataStream)obj;
        return Objects.equals(this.file, that.file) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.id);
    }

    public String toString() {
        return "AlternateDataStream[file=" + this.file + ", id=" + this.id + ']';
    }

    public OutputStream openOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.file.getPath() + ":" + this.id);
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file.getPath() + ":" + this.id);
    }

    public Reader openReader() throws FileNotFoundException {
        return new FileReader(this.file.getPath() + ":" + this.id);
    }

    public Writer openWriter() throws IOException {
        return new FileWriter(this.file.getPath() + ":" + this.id);
    }

    public String getPath() {
        return this.file.getPath() + ":" + this.id;
    }

    public Path toPath() {
        return this.file.toPath();
    }
}

