/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class Percentage
implements Serializable,
Comparable<Percentage> {
    private final double percentage;
    private static final long serialVersionUID = 0L;

    public double percentage() {
        return this.percentage;
    }

    public Percentage(double percentage) {
        this.percentage = percentage;
    }

    public static Percentage toPercentage(double value) {
        return new Percentage(value * 100.0);
    }

    public double value() {
        return this.percentage / 100.0;
    }

    @Override
    public int compareTo(@NotNull Percentage o) {
        return Double.compare(this.percentage, o.percentage);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Percentage that = (Percentage)obj;
        return Double.doubleToLongBits(this.percentage) == Double.doubleToLongBits(that.percentage);
    }

    public String toString() {
        return "Percentage[percentage=" + this.percentage + ']';
    }
}

