/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.tables;

import com.ultreon.libs.collections.v0.tables.AbstractTable;
import com.ultreon.libs.collections.v0.tables.HashTable;
import com.ultreon.libs.collections.v0.tables.Table;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class Tables {
    private Tables() {
        throw new UnsupportedOperationException("Instantiation of utility class");
    }

    public static <R, C, V> Table<R, C, V> hashTableOf(Table<R, C, V> table) {
        return new HashTable<R, C, V>(table);
    }

    public static <R, C, V> Table<R, C, V> emptyTable() {
        return new AbstractTable<R, C, V>(){

            @Override
            public Set<Table.Cell<R, C, V>> cellSet() {
                return new HashSet();
            }
        };
    }

    public static <R, C, V> Table<R, C, V> unmodifiableTable(Table<R, C, V> table) {
        return new UnmodifiableTable<R, C, V>(table);
    }

    private static class UnmodifiableTable<R, C, V>
    extends AbstractTable<R, C, V> {
        private final Table<R, C, V> table;

        public UnmodifiableTable(Table<R, C, V> table) {
            this.table = table;
        }

        @Override
        public V put(R row, C column, V value) {
            throw new UnsupportedOperationException("Unmodifiable table");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable table");
        }

        @Override
        @Nullable
        public V remove(R row, C column) {
            throw new UnsupportedOperationException("Unmodifiable table");
        }

        @Override
        public Set<Table.Cell<R, C, V>> cellSet() {
            return this.table.cellSet();
        }
    }
}

