/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.tables;

import com.ultreon.libs.collections.v0.tables.AbstractTable;
import com.ultreon.libs.collections.v0.tables.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashTable<R, C, V>
extends AbstractTable<R, C, V> {
    private final Map<R, Map<C, V>> rowMap = new HashMap<R, Map<C, V>>();
    private final Map<C, Map<R, V>> columnMap = new HashMap<C, Map<R, V>>();

    public HashTable() {
    }

    public HashTable(Table<R, C, V> table) {
        for (R row : table.rowSet()) {
            for (C column : table.columnSet(row)) {
                this.put(row, column, table.get(row, column));
            }
        }
    }

    public static <R, C, V> HashTable<R, C, V> ofRowMap(Map<R, Map<C, V>> rowMap) {
        HashTable<R, C, V> table = new HashTable<R, C, V>();
        for (R row : rowMap.keySet()) {
            for (C column : rowMap.get(row).keySet()) {
                table.put(row, column, rowMap.get(row).get(column));
            }
        }
        return table;
    }

    public static <R, C, V> HashTable<R, C, V> ofColumnMap(Map<C, Map<R, V>> columnMap) {
        HashTable<R, C, V> table = new HashTable<R, C, V>();
        for (C column : columnMap.keySet()) {
            for (R row : columnMap.get(column).keySet()) {
                table.put(row, column, columnMap.get(column).get(row));
            }
        }
        return table;
    }

    public static <R, C, V> HashTable<R, C, V> of(Table<R, C, V> table) {
        return new HashTable<R, C, V>(table);
    }

    @Override
    public int columnSize() {
        return this.columnSet().size();
    }

    @Override
    public int rowSize() {
        return this.rowSet().size();
    }

    @Override
    public V get(R row, C column) {
        return this.rowMap.getOrDefault(row, Collections.emptyMap()).get(column);
    }

    @Override
    public V getOrDefault(R row, C column, V defaultValue) {
        return this.rowMap.getOrDefault(row, Collections.emptyMap()).getOrDefault(column, defaultValue);
    }

    @Override
    @Nullable
    public V put(R row, C column, V value) {
        V v = this.get(row, column);
        this.rowMap.computeIfAbsent(row, k -> new HashMap()).put(column, value);
        this.columnMap.computeIfAbsent(column, k -> new HashMap()).put(row, value);
        return v;
    }

    @Override
    @NotNull
    public Map<C, V> row(R row) {
        return Collections.unmodifiableMap(this.rowMap.get(row));
    }

    @Override
    @NotNull
    public Map<R, V> column(C column) {
        return Collections.unmodifiableMap(this.columnMap.get(column));
    }

    @Override
    public Set<R> rowSet() {
        return Collections.unmodifiableSet(this.rowMap.keySet());
    }

    @Override
    public Set<C> columnSet() {
        return Collections.unmodifiableSet(this.columnMap.keySet());
    }

    @Override
    public Set<R> rowSet(C column) {
        return Collections.unmodifiableSet(this.columnMap.getOrDefault(column, Collections.emptyMap()).keySet());
    }

    @Override
    public Set<C> columnSet(R row) {
        return Collections.unmodifiableSet(this.rowMap.getOrDefault(row, Collections.emptyMap()).keySet());
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (R row : this.rowMap.keySet()) {
            for (C column : this.rowMap.get(row).keySet()) {
                values.add(this.rowMap.get(row).get(column));
            }
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public Map<Table.Index<R, C>, V> toMap() {
        HashMap<Table.Index<R, C>, V> map = new HashMap<Table.Index<R, C>, V>();
        for (R row : this.rowMap.keySet()) {
            for (C column : this.rowMap.get(row).keySet()) {
                map.put(HashTable.index(row, column), this.rowMap.get(row).get(column));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @NotNull
    public Map<R, Map<C, V>> toRowMap() {
        HashMap<R, Map<C, V>> map = new HashMap<R, Map<C, V>>();
        for (R row : this.rowMap.keySet()) {
            map.put(row, Collections.unmodifiableMap(this.rowMap.get(row)));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @NotNull
    public Map<C, Map<R, V>> toColumnMap() {
        HashMap<C, Map<R, V>> map = new HashMap<C, Map<R, V>>();
        for (C column : this.columnMap.keySet()) {
            map.put(column, Collections.unmodifiableMap(this.columnMap.get(column)));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @Nullable
    public V remove(R row, C column) {
        Object value = this.rowMap.getOrDefault(row, Collections.emptyMap()).remove(column);
        if (value != null) {
            this.columnMap.getOrDefault(column, Collections.emptyMap()).remove(row);
        }
        return value;
    }

    @Override
    public void clear() {
        this.rowMap.clear();
        this.columnMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.rowMap.isEmpty() && this.columnMap.isEmpty();
    }

    @Override
    public boolean contains(R row, C column) {
        return this.rowMap.containsKey(row) && this.columnMap.containsKey(column);
    }

    public String toString() {
        return this.toMap().toString();
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        HashSet<Table.Cell<R, C, V>> cells = new HashSet<Table.Cell<R, C, V>>();
        for (R row : this.rowMap.keySet()) {
            for (C column : this.rowMap.get(row).keySet()) {
                cells.add(HashTable.cell(row, column, this.rowMap.get(row).get(column)));
            }
        }
        return Collections.unmodifiableSet(cells);
    }

    @Override
    public Set<Table.Index<R, C>> indexSet() {
        HashSet<AbstractTable.SimpleIndex<R, C>> indices = new HashSet<AbstractTable.SimpleIndex<R, C>>();
        for (R row : this.rowMap.keySet()) {
            for (C column : this.rowMap.get(row).keySet()) {
                indices.add(new AbstractTable.SimpleIndex<R, C>(row, column));
            }
        }
        return Collections.unmodifiableSet(indices);
    }
}

