/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.tables;

import com.ultreon.libs.collections.v0.tables.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    public static <R, C> Table.Index<R, C> index(R row, C column) {
        return new SimpleIndex<R, C>(row, column);
    }

    public static <R, C, V> Table.Cell<R, C, V> cell(R row, C column, V value) {
        return new SimpleCell<R, C, V>(row, column, value);
    }

    @Override
    public int columnSize() {
        return this.columnSet().size();
    }

    @Override
    public int rowSize() {
        return this.rowSet().size();
    }

    @Override
    public V put(R row, C column, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getOrDefault(R row, C column, V defaultValue) {
        V value = this.get(row, column);
        return value != null ? value : defaultValue;
    }

    @Override
    @Nullable
    public V remove(R row, C column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public V get(Table.Index<R, C> index) {
        return this.get(index.getRow(), index.getColumn());
    }

    @Override
    public V get(R row, C column) {
        return this.row(row).get(column);
    }

    @Override
    @NotNull
    public Map<C, V> row(R row) {
        HashMap map = new HashMap();
        for (Table.Cell cell : this.cellSet()) {
            if (!cell.getRow().equals(row)) continue;
            map.put(cell.getColumn(), cell.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @NotNull
    public Map<R, V> column(C column) {
        HashMap map = new HashMap();
        for (Table.Cell cell : this.cellSet()) {
            if (!cell.getColumn().equals(column)) continue;
            map.put(cell.getRow(), cell.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @NotNull
    public Map<R, Map<C, V>> toRowMap() {
        HashMap<R, Map<C, V>> map = new HashMap<R, Map<C, V>>();
        for (R row : this.rowSet()) {
            map.put(row, this.row(row));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @NotNull
    public Map<C, Map<R, V>> toColumnMap() {
        HashMap<C, Map<R, V>> map = new HashMap<C, Map<R, V>>();
        for (C column : this.columnSet()) {
            map.put(column, this.column(column));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Set<R> rowSet() {
        HashSet set = new HashSet();
        for (Table.Cell cell : this.cellSet()) {
            set.add(cell.getRow());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set<R> rowSet(C column) {
        HashSet set = new HashSet();
        for (Table.Cell cell : this.cellSet()) {
            if (!cell.getColumn().equals(column)) continue;
            set.add(cell.getRow());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set<C> columnSet(R row) {
        HashSet set = new HashSet();
        for (Table.Cell cell : this.cellSet()) {
            if (!cell.getRow().equals(row)) continue;
            set.add(cell.getColumn());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set<C> columnSet() {
        HashSet set = new HashSet();
        for (Table.Cell cell : this.cellSet()) {
            set.add(cell.getColumn());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set<Table.Index<R, C>> indexSet() {
        HashSet set = new HashSet();
        for (Table.Cell cell : this.cellSet()) {
            set.add(new SimpleIndex(cell.getRow(), cell.getColumn()));
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Collection<V> values() {
        HashSet set = new HashSet();
        for (Table.Cell cell : this.cellSet()) {
            set.add(cell.getValue());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public boolean contains(R row, C column) {
        return this.contains(AbstractTable.index(row, column));
    }

    @Override
    public boolean contains(Table.Index<R, C> index) {
        return this.indexSet().contains(index);
    }

    @Override
    public boolean isEmpty() {
        return this.indexSet().isEmpty();
    }

    @Override
    public boolean containsRow(R row) {
        return this.rowSet().contains(row);
    }

    @Override
    public boolean containsColumn(C column) {
        return this.columnSet().contains(column);
    }

    @Override
    public boolean containsAll(Table<R, C, V> table) {
        return table.cellSet().stream().allMatch(this::contains);
    }

    @Override
    public Map<Table.Index<R, C>, V> toMap() {
        HashMap map = new HashMap();
        for (Table.Cell cell : this.cellSet()) {
            map.put(new SimpleIndex(cell.getRow(), cell.getColumn()), cell.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static class SimpleIndex<R, C>
    implements Table.Index<R, C> {
        private final R row;
        private final C column;

        public SimpleIndex(R row, C column) {
            this.row = row;
            this.column = column;
        }

        public int hashCode() {
            return this.row.hashCode() ^ this.column.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleIndex other = (SimpleIndex)obj;
            return Objects.equals(this.row, other.row) && Objects.equals(this.column, other.column);
        }

        public String toString() {
            return "(" + this.row + ", " + this.column + ")";
        }

        @Override
        public R getRow() {
            return this.row;
        }

        @Override
        public C getColumn() {
            return this.column;
        }
    }

    public static class SimpleCell<R, C, V>
    implements Table.Cell<R, C, V> {
        private final R row;
        private final C column;
        private final V value;

        public SimpleCell(R row, C column, V value) {
            this.row = row;
            this.column = column;
            this.value = value;
        }

        public int hashCode() {
            return this.row.hashCode() ^ this.column.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleCell other = (SimpleCell)obj;
            return Objects.equals(this.row, other.row) && Objects.equals(this.column, other.column) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            return "(" + this.row + ", " + this.column + ")=" + this.value;
        }

        @Override
        public R getRow() {
            return this.row;
        }

        @Override
        public C getColumn() {
            return this.column;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

