/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.resources.v0;

import com.ultreon.libs.commons.v0.Identifier;
import com.ultreon.libs.commons.v0.Logger;
import com.ultreon.libs.commons.v0.exceptions.SyntaxException;
import com.ultreon.libs.commons.v0.util.IOUtils;
import com.ultreon.libs.functions.v0.misc.ThrowingSupplier;
import com.ultreon.libs.resources.v0.Resource;
import com.ultreon.libs.resources.v0.ResourcePackage;
import com.ultreon.libs.resources.v0.android.DeferredResourcePackage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceManager {
    private final Map<Identifier, byte[]> assets = new ConcurrentHashMap<Identifier, byte[]>();
    protected final List<ResourcePackage> resourcePackages = new ArrayList<ResourcePackage>();
    public static Logger logger = (level, msg, t) -> {};
    private final String root;

    public ResourceManager(String root) {
        this.root = root;
    }

    public boolean canScanFiles() {
        return true;
    }

    public InputStream openResourceStream(Identifier entry) {
        @Nullable Resource resource = this.getResource(entry);
        return resource == null ? null : resource.openStream();
    }

    @Nullable
    public Resource getResource(Identifier entry) {
        for (ResourcePackage resourcePackage : this.resourcePackages) {
            if (!resourcePackage.has(entry)) continue;
            return resourcePackage.get(entry);
        }
        logger.warn("Unknown resource: " + entry);
        return null;
    }

    public void importDeferredPackage(Class<?> ref) {
        this.resourcePackages.add(new DeferredResourcePackage(ref, this.root));
    }

    public void importPackage(URL url) throws IOException {
        if (url.getProtocol().equals("file")) {
            try {
                this.importPackage(new File(url.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else if (url.getProtocol().equals("jar")) {
            this.importFilePackage(new ZipInputStream(new URL(url.getPath().split("!/", 2)[0]).openStream()));
        } else {
            this.importFilePackage(new ZipInputStream(url.openStream()));
        }
    }

    public void importPackage(Path path) throws IOException {
        this.importPackage(path.toUri().toURL());
    }

    public void importPackage(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Resource package doesn't exists: " + file.getAbsolutePath());
        }
        if (file.isFile()) {
            if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                this.importFilePackage(new ZipInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
            } else {
                logger.warn("Resource package isn't a .jar or .zip file: " + file.getPath());
            }
        } else if (file.isDirectory()) {
            this.importDirectoryPackage(file);
        }
    }

    private void importDirectoryPackage(File file) {
        block13: {
            assert (file.isDirectory());
            try {
                HashMap<Identifier, Resource> map = new HashMap<Identifier, Resource>();
                File assets = new File(file, this.root + "/");
                if (!assets.exists()) break block13;
                File[] files = assets.listFiles();
                for (File assetsPackage : files != null ? files : new File[]{}) {
                    String namespace = assetsPackage.getName();
                    try (Stream<Path> walk = Files.walk(assetsPackage.toPath(), new FileVisitOption[0]);){
                        for (Path assetPath : walk.collect(Collectors.toList())) {
                            Identifier entry;
                            File asset = assetPath.toFile();
                            if (!asset.isFile()) continue;
                            ThrowingSupplier sup = () -> Files.newInputStream(asset.toPath(), new OpenOption[0]);
                            Resource resource = new Resource((ThrowingSupplier<InputStream, IOException>)sup);
                            if (assetPath.toFile().equals(assetsPackage)) continue;
                            Path relative = assetsPackage.toPath().relativize(assetPath);
                            String s = relative.toString().replaceAll("\\\\", "/");
                            try {
                                entry = new Identifier(namespace, s);
                            }
                            catch (SyntaxException e) {
                                logger.error("Invalid resource identifier:", (Throwable)e);
                                continue;
                            }
                            map.put(entry, resource);
                        }
                    }
                }
                this.resourcePackages.add(new ResourcePackage(map));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void importFilePackage(ZipInputStream file) throws IOException {
        HashMap<Identifier, Resource> map = new HashMap<Identifier, Resource>();
        try {
            ZipEntry entry;
            while ((entry = file.getNextEntry()) != null) {
                String name = entry.getName();
                byte[] bytes = IOUtils.readAllBytes((InputStream)file);
                ThrowingSupplier sup = () -> new ByteArrayInputStream(bytes);
                if (!entry.isDirectory()) {
                    this.addEntry(map, name, (ThrowingSupplier<InputStream, IOException>)sup);
                }
                file.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resourcePackages.add(new ResourcePackage(map));
        file.close();
    }

    private void addEntry(Map<Identifier, Resource> map, String name, ThrowingSupplier<InputStream, IOException> sup) {
        String[] splitPath = name.split("/", 3);
        if (splitPath.length >= 3 && name.startsWith(this.root + "/")) {
            String namespace = splitPath[1];
            String path = splitPath[2];
            Resource resource = new Resource(sup);
            try {
                Identifier entry = new Identifier(namespace, path);
                map.put(entry, resource);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    public List<byte[]> getAllDataByPath(@NotNull String path) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (ResourcePackage resourcePackage : this.resourcePackages) {
            Map<Identifier, Resource> identifierResourceMap = resourcePackage.mapEntries();
            for (Map.Entry<Identifier, Resource> entry : identifierResourceMap.entrySet()) {
                byte[] bytes;
                if (!entry.getKey().path().equals(path) || (bytes = entry.getValue().loadOrGet()) == null) continue;
                data.add(entry.getValue().getData());
            }
        }
        return data;
    }

    @NotNull
    public List<byte[]> getAllDataById(@NotNull Identifier id) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (ResourcePackage resourcePackage : this.resourcePackages) {
            byte[] bytes;
            Resource resource;
            if (!resourcePackage.has(id) || (resource = resourcePackage.get(id)) == null || (bytes = resource.loadOrGet()) == null) continue;
            data.add(resource.getData());
        }
        return data;
    }

    public String getRoot() {
        return this.root;
    }
}

