/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.resources.v0;

import com.ultreon.libs.commons.v0.util.IOUtils;
import com.ultreon.libs.functions.v0.misc.ThrowingSupplier;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Resource {
    protected ThrowingSupplier<InputStream, IOException> opener;
    private byte[] data;
    private BufferedImage image;

    public Resource(ThrowingSupplier<InputStream, IOException> opener) {
        this.opener = opener;
    }

    public void load() {
        try (InputStream inputStream = (InputStream)this.opener.get();){
            this.data = IOUtils.readAllBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] loadOrGet() {
        if (this.data == null) {
            this.load();
        }
        return this.getData();
    }

    public InputStream loadOrOpenStream() {
        return new ByteArrayInputStream(this.loadOrGet());
    }

    protected Image loadImage() {
        BufferedImage bufferedImage;
        block8: {
            InputStream inputStream = (InputStream)this.opener.get();
            try {
                bufferedImage = ImageIO.read(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    public byte[] getData() {
        return this.data;
    }

    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.loadOrGet());
    }

    public Font loadFont() throws FontFormatException {
        Font font;
        block8: {
            InputStream inputStream = (InputStream)this.opener.get();
            try {
                font = Font.createFont(0, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return font;
    }

    public BufferedImage readImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        this.image = ImageIO.read(this.openStream());
        return this.image;
    }
}

