/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.crash.v0;

import com.ultreon.libs.crash.v0.CrashLog;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ApplicationCrash {
    private static final List<Runnable> crashHandlers = new ArrayList<Runnable>();
    @NotNull
    private final CrashLog crashLog;

    ApplicationCrash(@NotNull CrashLog crashLog) {
        this.crashLog = crashLog;
    }

    public void printCrash() {
        String[] strings;
        String crashString = this.crashLog.toString();
        for (String string : strings = crashString.split("(\r\n|\r|\n)")) {
            System.err.println(string);
        }
    }

    private void crash() {
        for (Runnable handler : crashHandlers) {
            handler.run();
        }
    }

    public static void onCrash(Runnable handler) {
        crashHandlers.add(handler);
    }

    @NotNull
    public CrashLog getCrashLog() {
        return this.crashLog;
    }
}

