/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.util;

import com.ultreon.data.types.IType;
import com.ultreon.data.types.ListType;
import com.ultreon.data.types.MapType;
import java.util.Iterator;
import java.util.Map;

public interface DataTypeVisitor<T> {
    public static final DataTypeVisitor<String> WRITE_USO = IType::writeUso;

    public T visit(IType<?> var1);

    public static DataTypeVisitor<IType<?>> deepCopy() {
        return type1 -> {
            if (type1 instanceof ListType) {
                ListType original = (ListType)type1;
                ListType<IType> listType = new ListType<IType>(original.type());
                Iterator iterator = ((ListType)type1).getValue().iterator();
                while (iterator.hasNext()) {
                    IType iType = (IType)iterator.next();
                    listType.add(DataTypeVisitor.deepCopy(iType));
                }
                return listType;
            }
            if (type1 instanceof MapType) {
                MapType mapType = new MapType();
                for (Map.Entry entry : ((MapType)type1).getValue().entrySet()) {
                    mapType.put((String)entry.getKey(), DataTypeVisitor.deepCopy((IType)entry.getValue()));
                }
                return mapType;
            }
            return type1.copy();
        };
    }

    public static <T extends IType<?>> T deepCopy(T type) {
        return (T)type.accept(DataTypeVisitor.deepCopy());
    }
}

