/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LongType
implements IType<Long> {
    private long obj;

    public LongType(long obj) {
        this.obj = obj;
    }

    @Override
    public Long getValue() {
        return this.obj;
    }

    @Override
    public void setValue(Long obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj;
    }

    @Override
    public int id() {
        return Types.LONG;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeLong(this.obj);
    }

    public static LongType read(DataInputStream stream) throws IOException {
        return new LongType(stream.readLong());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LongType)) {
            return false;
        }
        LongType longType = (LongType)other;
        return this.obj == longType.obj;
    }

    @Override
    public int hashCode() {
        return (int)(this.obj ^ this.obj >>> 32);
    }

    public LongType copy() {
        return new LongType(this.obj);
    }

    @Override
    public String writeUso() {
        return this.obj + "l";
    }

    public String toString() {
        return this.writeUso();
    }
}

