/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class DoubleArrayType
implements IType<double[]> {
    private double[] obj;

    public DoubleArrayType(double[] obj) {
        this.obj = obj;
    }

    @Override
    public double[] getValue() {
        return this.obj;
    }

    @Override
    public void setValue(double[] obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj;
    }

    @Override
    public int id() {
        return Types.DOUBLE_ARRAY;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.obj.length);
        for (double i : this.obj) {
            stream.writeDouble(i);
        }
    }

    public static DoubleArrayType read(DataInputStream stream) throws IOException {
        int len = stream.readInt();
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = stream.readDouble();
        }
        return new DoubleArrayType(arr);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DoubleArrayType)) {
            return false;
        }
        DoubleArrayType that = (DoubleArrayType)other;
        return Arrays.equals(this.obj, that.obj);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.obj);
    }

    public DoubleArrayType copy() {
        return new DoubleArrayType((double[])this.obj.clone());
    }

    public int size() {
        return this.obj.length;
    }

    @Override
    public String writeUso() {
        StringBuilder builder = new StringBuilder("(d;");
        for (double v : this.obj) {
            builder.append(v).append(",");
        }
        if (this.obj.length > 0) {
            return builder.substring(0, builder.length() - 1) + ")";
        }
        return builder.append(")").toString();
    }

    public String toString() {
        return this.writeUso();
    }
}

