/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0.vector;

import com.ultreon.libs.commons.v0.vector.Vec2d;
import com.ultreon.libs.commons.v0.vector.Vec2i;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;

public class Vec2f
implements Externalizable,
Cloneable {
    public float x;
    public float y;

    public Vec2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2f() {
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public static Vec2f mul(Vec2f a, Vec2f b) {
        return new Vec2f(a.x * b.x, a.y * b.y);
    }

    public static Vec2f div(Vec2f a, Vec2f b) {
        return new Vec2f(a.x / b.x, a.y / b.y);
    }

    public static Vec2f add(Vec2f a, Vec2f b) {
        return new Vec2f(a.x + b.x, a.y + b.y);
    }

    public static Vec2f sub(Vec2f a, Vec2f b) {
        return new Vec2f(a.x - b.x, a.y - b.y);
    }

    public static float dot(Vec2f a, Vec2f b) {
        return a.x * b.x + a.y * b.y;
    }

    public static Vec2d pow(Vec2f a, Vec2f b) {
        return new Vec2d(Math.pow(a.x, b.x), Math.pow(a.y, b.y));
    }

    public float dot(Vec2f vec) {
        return this.x * vec.x + this.y * vec.y;
    }

    public float dot(float x, float y) {
        return this.x * x + this.y * y;
    }

    public float dot(float v) {
        return this.x * v + this.y * v;
    }

    public float len2() {
        return this.x * this.x + this.y * this.y;
    }

    public Vec2f nor() {
        float len2 = this.len2();
        if (len2 == 0.0f || len2 == 1.0f) {
            return this;
        }
        return this.mul(1.0f / (float)Math.sqrt(len2));
    }

    public double dst(Vec2f vec) {
        float a = vec.x - this.x;
        float b = vec.y - this.y;
        return Math.sqrt(a * a + b * b);
    }

    public double dst(float x, float y) {
        float a = x - this.x;
        float b = y - this.y;
        return Math.sqrt(a * a + b * b);
    }

    public Vec2f set(Vec2f vec) {
        this.x = vec.x;
        this.y = vec.y;
        return this;
    }

    public Vec2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vec2f set(float v) {
        this.x = v;
        this.y = v;
        return this;
    }

    public Vec2f add(Vec2f vec) {
        this.x += vec.x;
        this.y += vec.y;
        return this;
    }

    public Vec2f add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vec2f add(float v) {
        this.x += v;
        this.y += v;
        return this;
    }

    public Vec2f sub(Vec2f vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        return this;
    }

    public Vec2f sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vec2f sub(float v) {
        this.x -= v;
        this.y -= v;
        return this;
    }

    public Vec2f mul(Vec2f vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        return this;
    }

    public Vec2f mul(float x, float y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vec2f mul(float v) {
        this.x *= v;
        this.y *= v;
        return this;
    }

    public Vec2f div(Vec2f vec) {
        this.x /= vec.x;
        this.y /= vec.y;
        return this;
    }

    public Vec2f div(float x, float y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vec2f div(float v) {
        this.x /= v;
        this.y /= v;
        return this;
    }

    public Vec2f mod(Vec2f vec) {
        this.x %= vec.x;
        this.y %= vec.y;
        return this;
    }

    public Vec2f mod(float x, float y) {
        this.x %= x;
        this.y %= y;
        return this;
    }

    public Vec2f mod(float v) {
        this.x %= v;
        this.y %= v;
        return this;
    }

    public Vec2f pow(Vec2f vec) {
        this.x = (float)Math.pow(this.x, vec.x);
        this.y = (float)Math.pow(this.y, vec.y);
        return this;
    }

    public Vec2f pow(float x, float y) {
        this.x = (float)Math.pow(this.x, x);
        this.y = (float)Math.pow(this.y, y);
        return this;
    }

    public Vec2f pow(float v) {
        this.x = (float)Math.pow(this.x, v);
        this.y = (float)Math.pow(this.y, v);
        return this;
    }

    public Vec2f neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2f inc() {
        this.x += 1.0f;
        this.y += 1.0f;
        return this;
    }

    public Vec2f dec() {
        this.x -= 1.0f;
        this.y -= 1.0f;
        return this;
    }

    public Vec2f abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    public Vec2f floor() {
        this.x = (float)Math.floor(this.x);
        this.y = (float)Math.floor(this.y);
        return this;
    }

    public Vec2f ceil() {
        this.x = (float)Math.ceil(this.x);
        this.y = (float)Math.ceil(this.y);
        return this;
    }

    public Vec2f cpy() {
        return new Vec2f(this.x, this.y);
    }

    public Vec2d d() {
        return new Vec2d(this.x, this.y);
    }

    public Vec2f f() {
        return new Vec2f(this.x, this.y);
    }

    public Vec2i i() {
        return new Vec2i((int)this.x, (int)this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2f vec2F = (Vec2f)o;
        return Float.compare(vec2F.getX(), this.getX()) == 0 && Float.compare(vec2F.getY(), this.getY()) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.getX()), Float.valueOf(this.getY()));
    }

    public String toString() {
        return String.format("%f, %f", Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public Vec2f clone() {
        try {
            Vec2f clone = (Vec2f)super.clone();
            clone.x = this.x;
            clone.y = this.y;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
    }
}

