/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import com.ultreon.libs.commons.v0.IDownloader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class Downloader
implements IDownloader {
    private final URL url;
    private final OutputStream outputStream;
    private final int blockSize;
    private long bytesDownloaded;
    private long length;
    private boolean paused;

    public Downloader(URL url, File output, int blockSize) throws IOException {
        this(url, new FileOutputStream(output), blockSize);
    }

    public Downloader(URL url, OutputStream outputStream, int blockSize) {
        this.url = url;
        this.outputStream = outputStream;
        this.blockSize = blockSize;
    }

    @Override
    public void downloadSync() throws IOException {
        URLConnection connection = this.url.openConnection();
        this.length = connection.getContentLengthLong();
        try (BufferedInputStream in = new BufferedInputStream(this.url.openStream());){
            try (OutputStream fileOutputStream = this.outputStream;){
                int bytesRead;
                byte[] dataBuffer = new byte[1024];
                byte[] buf = new byte[this.blockSize];
                while ((bytesRead = in.read(buf)) >= 0) {
                    if (this.paused) {
                        Thread.sleep(10L);
                        continue;
                    }
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                    this.bytesDownloaded += (long)bytesRead;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public long getBytesDownloaded() {
        return this.bytesDownloaded;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public float getPercent() {
        if (this.length == -1L) {
            return Float.MIN_VALUE;
        }
        return 100.0f * this.getRatio();
    }

    @Override
    public float getRatio() {
        if (this.length == -1L) {
            return Float.MIN_VALUE;
        }
        return (float)((double)this.bytesDownloaded / (double)this.length);
    }
}

