/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.tables;

import com.ultreon.libs.collections.v0.tables.AbstractTable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public interface Table<R, C, V> {
    public static <R, C, V> Table<R, C, V> copyOf(Table<R, C, V> table) {
        final Set<Cell<R, C, V>> cells = Collections.unmodifiableSet(table.cellSet());
        return new AbstractTable<R, C, V>(){

            @Override
            public Set<Cell<R, C, V>> cellSet() {
                return cells;
            }
        };
    }

    public int columnSize();

    public int rowSize();

    public V get(R var1, C var2);

    public V getOrDefault(R var1, C var2, V var3);

    public V put(R var1, C var2, V var3);

    default public V putIfAbsent(R row, C column, V value) {
        V v = this.get(row, column);
        if (v == null) {
            this.put(row, column, value);
            v = value;
        }
        return v;
    }

    default public V putIfPresent(R row, C column, V value) {
        V v = this.get(row, column);
        if (v != null) {
            this.put(row, column, value);
            v = value;
        }
        return v;
    }

    public Map<C, V> row(R var1);

    public Map<R, V> column(C var1);

    public Set<R> rowSet();

    public Set<C> columnSet();

    public Collection<V> values();

    public Map<R, Map<C, V>> toRowMap();

    public Map<C, Map<R, V>> toColumnMap();

    public V remove(R var1, C var2);

    public void clear();

    public boolean isEmpty();

    public boolean contains(R var1, C var2);

    default public boolean contains(Index<R, C> index) {
        return this.contains(index.getRow(), index.getColumn());
    }

    default public boolean containsRow(R row) {
        return this.rowSet().contains(row);
    }

    default public boolean containsColumn(C column) {
        return this.columnSet().contains(column);
    }

    default public boolean containsValue(V value) {
        return this.values().contains(value);
    }

    public boolean containsAll(Table<R, C, V> var1);

    public Set<Cell<R, C, V>> cellSet();

    public Map<Index<R, C>, V> toMap();

    default public V get(Index<R, C> index) {
        return this.get(index.getRow(), index.getColumn());
    }

    public Set<C> columnSet(R var1);

    public Set<R> rowSet(C var1);

    public Set<Index<R, C>> indexSet();

    public static interface Index<R, C> {
        public R getRow();

        public C getColumn();
    }

    public static interface Cell<R, C, V>
    extends Index<R, C> {
        @Override
        public R getRow();

        @Override
        public C getColumn();

        public V getValue();
    }
}

