/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PagedList<T>
extends ArrayList<T> {
    private final int pageSize;

    public PagedList(int pageSize, int initialCapacity) {
        super(initialCapacity);
        this.pageSize = pageSize;
    }

    public PagedList(int pageSize) {
        this.pageSize = pageSize;
    }

    public PagedList(int pageSize, @NotNull Collection<? extends T> collection) {
        super(collection);
        this.pageSize = pageSize;
    }

    public PagedList(@NotNull PagedList<? extends T> paginatedList) {
        super(paginatedList);
        this.pageSize = paginatedList.pageSize;
    }

    public List<T> getFullPage(int page) {
        return super.subList(page * this.pageSize, page * this.pageSize + this.pageSize - 1);
    }

    public T get(int page, int index) {
        if (index >= this.pageSize) {
            return null;
        }
        return (T)super.get(page * this.pageSize + index);
    }
}

