/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.functions.v0.supplier;

import com.ultreon.libs.functions.v0.supplier.IntSupplier;
import java.util.function.Supplier;

@FunctionalInterface
public interface FloatSupplier
extends Supplier<Float> {
    @Override
    @Deprecated
    default public Float get() {
        return Float.valueOf(this.getFloat());
    }

    public float getFloat();

    default public FloatSupplier add(FloatSupplier supplier) {
        return () -> this.getFloat() + supplier.getFloat();
    }

    default public FloatSupplier sub(FloatSupplier supplier) {
        return () -> this.getFloat() - supplier.getFloat();
    }

    default public FloatSupplier mul(FloatSupplier supplier) {
        return () -> this.getFloat() * supplier.getFloat();
    }

    default public FloatSupplier div(FloatSupplier supplier) {
        return () -> this.getFloat() / supplier.getFloat();
    }

    default public FloatSupplier mod(FloatSupplier supplier) {
        return () -> this.getFloat() % supplier.getFloat();
    }

    default public FloatSupplier pow(FloatSupplier supplier) {
        return () -> (float)Math.pow(this.getFloat(), supplier.getFloat());
    }

    default public FloatSupplier sqrt() {
        return () -> (float)Math.sqrt(this.getFloat());
    }

    default public IntSupplier round() {
        return () -> Math.round(this.getFloat());
    }

    default public FloatSupplier roundFloat() {
        return () -> Math.round(this.getFloat());
    }

    default public FloatSupplier sin() {
        return () -> (float)Math.sin(this.getFloat());
    }

    default public FloatSupplier cos() {
        return () -> (float)Math.cos(this.getFloat());
    }

    default public FloatSupplier tan() {
        return () -> (float)Math.tan(this.getFloat());
    }

    default public FloatSupplier asin() {
        return () -> (float)Math.asin(this.getFloat());
    }

    default public FloatSupplier acos() {
        return () -> (float)Math.acos(this.getFloat());
    }

    default public FloatSupplier atan() {
        return () -> (float)Math.atan(this.getFloat());
    }

    default public FloatSupplier atan2(FloatSupplier supplier) {
        return () -> (float)Math.atan2(this.getFloat(), supplier.getFloat());
    }

    default public FloatSupplier sinh() {
        return () -> (float)Math.sinh(this.getFloat());
    }

    default public FloatSupplier cosh() {
        return () -> (float)Math.cosh(this.getFloat());
    }

    default public FloatSupplier tanh() {
        return () -> (float)Math.tanh(this.getFloat());
    }
}

