/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.functions.v0.supplier;

import java.util.function.Supplier;

@FunctionalInterface
public interface ByteSupplier
extends Supplier<Byte> {
    @Override
    @Deprecated
    default public Byte get() {
        return this.getByte();
    }

    public byte getByte();

    default public ByteSupplier and(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() & supplier.getByte());
    }

    default public ByteSupplier or(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() | supplier.getByte());
    }

    default public ByteSupplier add(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() + supplier.getByte());
    }

    default public ByteSupplier sub(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() - supplier.getByte());
    }

    default public ByteSupplier mul(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() * supplier.getByte());
    }

    default public ByteSupplier div(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() / supplier.getByte());
    }

    default public ByteSupplier mod(ByteSupplier supplier) {
        return () -> (byte)(this.getByte() % supplier.getByte());
    }

    default public ByteSupplier pow(ByteSupplier supplier) {
        return () -> (byte)Math.pow(this.getByte(), supplier.getByte());
    }

    default public ByteSupplier sqrt() {
        return () -> (byte)Math.sqrt(this.getByte());
    }

    default public ByteSupplier round() {
        return () -> (byte)Math.round(this.getByte());
    }

    default public ByteSupplier sin() {
        return () -> (byte)Math.sin(this.getByte());
    }

    default public ByteSupplier cos() {
        return () -> (byte)Math.cos(this.getByte());
    }

    default public ByteSupplier tan() {
        return () -> (byte)Math.tan(this.getByte());
    }

    default public ByteSupplier asin() {
        return () -> (byte)Math.asin(this.getByte());
    }

    default public ByteSupplier acos() {
        return () -> (byte)Math.acos(this.getByte());
    }

    default public ByteSupplier atan() {
        return () -> (byte)Math.atan(this.getByte());
    }

    default public ByteSupplier atan2(ByteSupplier supplier) {
        return () -> (byte)Math.atan2(this.getByte(), supplier.getByte());
    }

    default public ByteSupplier sinh() {
        return () -> (byte)Math.sinh(this.getByte());
    }

    default public ByteSupplier cosh() {
        return () -> (byte)Math.cosh(this.getByte());
    }

    default public ByteSupplier tanh() {
        return () -> (byte)Math.tanh(this.getByte());
    }
}

