/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.datetime.v0;

import com.ultreon.libs.datetime.v0.DateTime;
import com.ultreon.libs.datetime.v0.Duration;
import com.ultreon.libs.datetime.v0.exceptions.InvalidOrderException;
import java.io.Serializable;

public class TimeSpan
implements Serializable,
Cloneable {
    private DateTime from;
    private DateTime to;

    public TimeSpan(DateTime from, DateTime to) {
        if (from.toEpochNano() > to.toEpochNano()) {
            throw new InvalidOrderException("Parameter \u2018from\u2019 is later than \u2018to\u2019.");
        }
        this.from = from;
        this.to = to;
    }

    public boolean contains(DateTime dateTime) {
        return DateTime.isBetween(this.from, this.to);
    }

    public Duration toDuration() {
        return Duration.ofNanoseconds(this.to.toEpochNano() - this.from.toEpochNano());
    }

    public DateTime getFrom() {
        return this.from;
    }

    public DateTime getTo() {
        return this.to;
    }

    public void setFrom(DateTime from) {
        this.from = from;
    }

    public void setTo(DateTime to) {
        this.to = to;
    }

    public TimeSpan clone() {
        try {
            return (TimeSpan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

